/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;

public final class ItemList
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(ItemList.class.getName());
    private static final String _S__11_ITEMLIST = "[S] 11 ItemList";
    private L2ItemInstance[] _items;
    private boolean _showWindow;

    public ItemList(L2PcInstance cha, boolean showWindow) {
        this._items = cha.getInventory().getItems();
        this._showWindow = showWindow;
        if (Config.DEBUG) {
            this.showDebug();
        }
    }

    public ItemList(L2ItemInstance[] items, boolean showWindow) {
        this._items = items;
        this._showWindow = showWindow;
        if (Config.DEBUG) {
            this.showDebug();
        }
    }

    private void showDebug() {
        for (L2ItemInstance temp : this._items) {
            _log.fine("item:" + temp.getItem().getName() + " type1:" + temp.getItem().getType1() + " type2:" + temp.getItem().getType2());
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(17);
        this.writeH(this._showWindow ? 1 : 0);
        int count = this._items.length;
        this.writeH(count);
        for (L2ItemInstance temp : this._items) {
            if (temp == null || temp.getItem() == null) continue;
            this.writeH(temp.getItem().getType1());
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getLocationSlot());
            this.writeQ(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(temp.getCustomType1());
            this.writeH(temp.isEquipped() ? 1 : 0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(temp.getCustomType2());
            if (temp.isAugmented()) {
                this.writeD(temp.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(temp.getMana());
            this.writeH(temp.getAttackElementType());
            this.writeH(temp.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(temp.getElementDefAttr(i));
            }
            this.writeD(temp.isTimeLimitedItem() ? (int)(temp.getRemainingTime() / 1000L) : -1);
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__11_ITEMLIST;
    }
}

