/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public class FriendList
extends L2GameServerPacket {
    private static final String _S__FA_FRIENDLIST = "[S] 75 FriendList";
    private List<Integer> _friends;
    private L2PcInstance _activeChar;

    @Override
    public void runImpl() {
        if (this.getClient() != null && ((L2GameClient)this.getClient()).getActiveChar() != null) {
            this._activeChar = ((L2GameClient)this.getClient()).getActiveChar();
            this._friends = this._activeChar.getFriendList();
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(117);
        if (this._friends != null) {
            this.writeD(this._friends.size());
            for (int ObjId : this._friends) {
                String name = CharNameTable.getInstance().getNameById(ObjId);
                L2Object obj = L2World.getInstance().findObject(ObjId);
                boolean online = false;
                if (obj instanceof L2PcInstance && ((L2PcInstance)obj).isOnline() == 1) {
                    online = true;
                }
                this.writeD(ObjId);
                this.writeS(name);
                this.writeD(online ? 1 : 0);
                this.writeD(online ? ObjId : 0);
            }
        } else {
            this.writeD(0);
        }
    }

    @Override
    public String getType() {
        return _S__FA_FRIENDLIST;
    }
}

