/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import javolution.util.FastList;

public final class BuyListSeed
extends L2GameServerPacket {
    private static final String _S__E8_BUYLISTSEED = "[S] e9 BuyListSeed";
    private int _manorId;
    private List<Seed> _list = null;
    private long _money;

    public BuyListSeed(long currentMoney, int castleId, List<CastleManorManager.SeedProduction> seeds) {
        this._money = currentMoney;
        this._manorId = castleId;
        if (seeds != null && seeds.size() > 0) {
            this._list = new FastList();
            for (CastleManorManager.SeedProduction s : seeds) {
                if (s.getCanProduce() <= 0L || s.getPrice() <= 0L) continue;
                this._list.add(new Seed(s.getId(), s.getCanProduce(), s.getPrice()));
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(233);
        this.writeQ(this._money);
        this.writeD(this._manorId);
        if (this._list != null && this._list.size() > 0) {
            this.writeH(this._list.size());
            for (Seed s : this._list) {
                this.writeH(4);
                this.writeD(0);
                this.writeD(s._itemId);
                this.writeQ(s._count);
                this.writeH(4);
                this.writeH(0);
                this.writeQ(s._price);
            }
            this._list.clear();
        } else {
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__E8_BUYLISTSEED;
    }

    private class Seed {
        public final int _itemId;
        public final long _count;
        public final long _price;

        public Seed(int itemId, long count, long price) {
            this._itemId = itemId;
            this._count = count;
            this._price = price;
        }
    }
}

