/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.network.communityserver.readpackets.AuthResponse;
import com.l2jserver.gameserver.network.communityserver.readpackets.ClanNoticeInfo;
import com.l2jserver.gameserver.network.communityserver.readpackets.ConnectionError;
import com.l2jserver.gameserver.network.communityserver.readpackets.InitCS;
import com.l2jserver.gameserver.network.communityserver.readpackets.RequestPlayerShowBoard;
import com.l2jserver.gameserver.network.communityserver.readpackets.RequestPlayerShowMessage;
import com.l2jserver.gameserver.network.communityserver.readpackets.RequestWorldInfo;
import java.io.IOException;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netcon.BaseReadPacket;
import org.netcon.BaseWritePacket;
import org.netcon.NetConnection;
import org.netcon.NetConnectionConfig;

public final class CommunityServerThread
extends NetConnection {
    private static final Logger _log = Logger.getLogger(CommunityServerThread.class.getName());
    private static CommunityServerThread _instance;
    private boolean _authed;

    public static final void initialize() {
        if (_instance == null) {
            if (Config.ENABLE_COMMUNITY_BOARD) {
                try {
                    _instance = new CommunityServerThread(new NetConnectionConfig("./config/CommunityServer.properties"));
                    _instance.start();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "CommunityServerThread: Failed loading config file!", e);
                    e.printStackTrace();
                }
            } else {
                _log.log(Level.INFO, "CommunityServerThread: Deactivated by config.");
                _instance = new CommunityServerThread(null);
            }
        }
    }

    public static final CommunityServerThread getInstance() {
        return _instance;
    }

    private CommunityServerThread(NetConnectionConfig config) {
        super(config);
    }

    public final boolean isAuthed() {
        return this._authed;
    }

    public final void setAuthed(boolean authed) {
        this._authed = authed;
    }

    public final void forceClose(BaseWritePacket packet) {
        this._authed = false;
        try {
            super.close(packet);
        }
        catch (IOException e) {
            _log.log(Level.INFO, "CommunityServerThread: Failed disconnecting server, server already disconnected.");
            e.printStackTrace();
        }
    }

    public boolean sendPacket(BaseWritePacket packet) {
        return this.sendPacket(packet, true);
    }

    public boolean sendPacket(BaseWritePacket packet, boolean needAuth) {
        if (needAuth && !this._authed) {
            return false;
        }
        try {
            super.write(packet);
        }
        catch (IOException e) {
            _log.log(Level.INFO, "CommunityServerThread: Failed sending TCP packet.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void run() {
        _log.log(Level.INFO, "CommunityServerThread: Activated by config.");
        int packetType1 = 255;
        int packetType2 = 255;
        BaseReadPacket packet = null;
        byte[] data = null;
        while (!this.isInterrupted()) {
            try {
                NetConnection.sleep((long)10000L);
            }
            catch (InterruptedException e) {
                return;
            }
            _log.log(Level.INFO, "CommunityServerThread: Trying to connect to " + Config.COMMUNITY_SERVER_ADDRESS + " on port " + Config.COMMUNITY_SERVER_PORT + ".");
            try {
                _instance.connect(Config.COMMUNITY_SERVER_ADDRESS, Config.COMMUNITY_SERVER_PORT);
            }
            catch (SocketException se) {
                _log.log(Level.INFO, "CommunityServerThread: Connecting to " + Config.COMMUNITY_SERVER_ADDRESS + " on port " + Config.COMMUNITY_SERVER_PORT + " failed.");
                continue;
            }
            catch (IOException e) {
                _log.log(Level.INFO, "CommunityServerThread: Connection failed!", e);
                e.printStackTrace();
                continue;
            }
            try {
                long gameServerConnectStart = System.currentTimeMillis();
                while (!this.isInterrupted()) {
                    data = super.read();
                    packetType1 = data[0] & 0xFF;
                    packetType2 = data[1] & 0xFF;
                    if (Config.PACKET_HANDLER_DEBUG) {
                        _log.log(Level.INFO, "Received packet: 0x" + Integer.toHexString(packetType1) + "-0x" + Integer.toHexString(packetType2));
                    }
                    block3 : switch (packetType1) {
                        case 0: {
                            switch (packetType2) {
                                case 0: {
                                    packet = new InitCS(data, this);
                                    break;
                                }
                                case 1: {
                                    _log.info("Server connected in " + (System.currentTimeMillis() - gameServerConnectStart) / 1000L + " seconds");
                                    packet = new AuthResponse(data, this);
                                    break;
                                }
                                case 2: {
                                    packet = new ConnectionError(data);
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (packetType2) {
                                case 0: {
                                    packet = new RequestWorldInfo(data, this, 0);
                                    break;
                                }
                                case 1: {
                                    packet = new RequestWorldInfo(data, this, 1);
                                    break;
                                }
                                case 2: {
                                    packet = new RequestWorldInfo(data, this, 2);
                                    break;
                                }
                                case 3: {
                                    packet = new ClanNoticeInfo(data, 0);
                                    break;
                                }
                                case 4: {
                                    packet = new ClanNoticeInfo(data, 1);
                                    break;
                                }
                                case 5: {
                                    packet = new ClanNoticeInfo(data, this, 2);
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (packetType2) {
                                case 0: {
                                    packet = new RequestPlayerShowBoard(data);
                                    break block3;
                                }
                                case 1: {
                                    packet = new RequestPlayerShowMessage(data);
                                }
                            }
                        }
                    }
                    if (packet != null) {
                        ThreadPoolManager.getInstance().executeCommunityPacket((Runnable)packet);
                        continue;
                    }
                    throw new IOException("Invalid packet!");
                }
                if (!this.isInterrupted()) continue;
                this.forceClose(null);
            }
            catch (IOException e) {
                e.printStackTrace();
                _log.log(Level.WARNING, "CommunityServerThread: TCP Connection lost!");
                this.forceClose(null);
            }
        }
    }
}

