/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharCreateFail;
import com.l2jserver.gameserver.network.serverpackets.CharCreateOk;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.templates.chars.L2PcTemplate;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mmocore.network.SendablePacket;

public final class CharacterCreate
extends L2GameClientPacket {
    private static final String _C__0B_CHARACTERCREATE = "[C] 0B CharacterCreate";
    private static final Logger _log = Logger.getLogger(CharacterCreate.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    private String _name;
    private int _race;
    private byte _sex;
    private int _classId;
    private int _int;
    private int _str;
    private int _con;
    private int _men;
    private int _dex;
    private int _wit;
    private byte _hairStyle;
    private byte _hairColor;
    private byte _face;

    @Override
    protected void readImpl() {
        this._name = this.readS();
        this._race = this.readD();
        this._sex = (byte)this.readD();
        this._classId = this.readD();
        this._int = this.readD();
        this._str = this.readD();
        this._con = this.readD();
        this._men = this.readD();
        this._dex = this.readD();
        this._wit = this.readD();
        this._hairStyle = (byte)this.readD();
        this._hairColor = (byte)this.readD();
        this._face = (byte)this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        if (this._name.length() < 1 || this._name.length() > 16) {
            if (Config.DEBUG) {
                _log.fine("Character Creation Failure: Character name " + this._name + " is invalid. Message generated: Your title cannot exceed 16 characters in length. Please try again.");
            }
            this.sendPacket(new CharCreateFail(3));
            return;
        }
        if (!Util.isAlphaNumeric(this._name) || !this.isValidName(this._name)) {
            if (Config.DEBUG) {
                _log.fine("Character Creation Failure: Character name " + this._name + " is invalid. Message generated: Incorrect name. Please try again.");
            }
            this.sendPacket(new CharCreateFail(4));
            return;
        }
        if (this._face > 2 || this._face < 0) {
            _log.warning("Character Creation Failure: Character face " + this._face + " is invalid. Possible client hack. " + this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        if (this._hairStyle < 0 || this._sex == 0 && this._hairStyle > 4 || this._sex != 0 && this._hairStyle > 6) {
            _log.warning("Character Creation Failure: Character hair style " + this._hairStyle + " is invalid. Possible client hack. " + this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        if (this._hairColor > 3 || this._hairColor < 0) {
            _log.warning("Character Creation Failure: Character hair color " + this._hairColor + " is invalid. Possible client hack. " + this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        L2PcInstance newChar = null;
        L2PcTemplate template = null;
        CharNameTable charNameTable = CharNameTable.getInstance();
        synchronized (charNameTable) {
            if (CharNameTable.getInstance().accountCharNumber(((L2GameClient)this.getClient()).getAccountName()) >= Config.MAX_CHARACTERS_NUMBER_PER_ACCOUNT && Config.MAX_CHARACTERS_NUMBER_PER_ACCOUNT != 0) {
                if (Config.DEBUG) {
                    _log.fine("Max number of characters reached. Creation failed.");
                }
                this.sendPacket(new CharCreateFail(1));
                return;
            }
            if (CharNameTable.getInstance().doesCharNameExist(this._name)) {
                if (Config.DEBUG) {
                    _log.fine("Character Creation Failure: Message generated: You cannot create another character. Please delete the existing character and try again.");
                }
                this.sendPacket(new CharCreateFail(2));
                return;
            }
            template = CharTemplateTable.getInstance().getTemplate(this._classId);
            if (template == null || template.classBaseLevel > 1) {
                if (Config.DEBUG) {
                    _log.fine("Character Creation Failure: " + this._name + " classId: " + this._classId + " Template: " + template + " Message generated: Your character creation has failed.");
                }
                this.sendPacket(new CharCreateFail(0));
                return;
            }
            int objectId = IdFactory.getInstance().getNextId();
            newChar = L2PcInstance.create(objectId, template, ((L2GameClient)this.getClient()).getAccountName(), this._name, this._hairStyle, this._hairColor, this._face, this._sex != 0);
        }
        newChar.setCurrentHp(template.baseHpMax);
        newChar.setCurrentCp(template.baseCpMax);
        newChar.setCurrentMp(template.baseMpMax);
        CharCreateOk cco = new CharCreateOk();
        this.sendPacket(cco);
        this.initNewChar((L2GameClient)this.getClient(), newChar);
        LogRecord record = new LogRecord(Level.INFO, "Created new character");
        record.setParameters(new Object[]{newChar, this.getClient()});
        _logAccounting.log(record);
    }

    private boolean isValidName(String text) {
        Pattern pattern;
        boolean result = true;
        String test = text;
        try {
            pattern = Pattern.compile(Config.CNAME_TEMPLATE);
        }
        catch (PatternSyntaxException e) {
            _log.warning("ERROR : Character name pattern of config is wrong!");
            pattern = Pattern.compile(".*");
        }
        Matcher regexp = pattern.matcher(test);
        if (!regexp.matches()) {
            result = false;
        }
        return result;
    }

    private void initNewChar(L2GameClient client, L2PcInstance newChar) {
        if (Config.DEBUG) {
            _log.fine("Character init start");
        }
        L2World.getInstance().storeObject(newChar);
        L2PcTemplate template = newChar.getTemplate();
        newChar.addAdena("Init", Config.STARTING_ADENA, null, false);
        newChar.setXYZInvisible(template.spawnX, template.spawnY, template.spawnZ);
        newChar.setTitle("");
        newChar.setVitalityPoints(PcStat.MAX_VITALITY_POINTS, true);
        if (Config.STARTING_LEVEL > 1) {
            newChar.getStat().addLevel((byte)(Config.STARTING_LEVEL - 1));
        }
        if (Config.STARTING_SP > 0) {
            newChar.getStat().addSp(Config.STARTING_SP);
        }
        L2ShortCut shortcut = new L2ShortCut(0, 0, 3, 2, 0, 1);
        newChar.registerShortCut(shortcut);
        shortcut = new L2ShortCut(3, 0, 3, 5, 0, 1);
        newChar.registerShortCut(shortcut);
        shortcut = new L2ShortCut(10, 0, 3, 0, 0, 1);
        newChar.registerShortCut(shortcut);
        for (L2PcTemplate.PcTemplateItem ia : template.getItems()) {
            L2ItemInstance item = newChar.getInventory().addItem("Init", ia.getItemId(), ia.getAmount(), newChar, null);
            if (item == null) {
                _log.warning("Could not create item during char creation: itemId " + ia.getItemId() + ", amount " + ia.getAmount() + ".");
                continue;
            }
            if (item.getItemId() == 5588) {
                shortcut = new L2ShortCut(11, 0, 1, item.getObjectId(), 0, 1);
                newChar.registerShortCut(shortcut);
            }
            if (!item.isEquipable() || !ia.isEquipped()) continue;
            newChar.getInventory().equipItemAndRecord(item);
        }
        for (L2SkillLearn skill : SkillTreeTable.getInstance().getAvailableSkills(newChar, newChar.getClassId())) {
            newChar.addSkill(SkillTable.getInstance().getInfo(skill.getId(), skill.getLevel()), true);
            if (skill.getId() == 1001 || skill.getId() == 1177) {
                shortcut = new L2ShortCut(1, 0, 2, skill.getId(), skill.getLevel(), 1);
                newChar.registerShortCut(shortcut);
            }
            if (skill.getId() == 1216) {
                shortcut = new L2ShortCut(10, 0, 2, skill.getId(), skill.getLevel(), 1);
                newChar.registerShortCut(shortcut);
            }
            if (!Config.DEBUG) continue;
            _log.fine("Adding starter skill:" + skill.getId() + " / " + skill.getLevel());
        }
        if (!Config.DISABLE_TUTORIAL) {
            this.startTutorialQuest(newChar);
        }
        newChar.logout();
        CharSelectionInfo cl = new CharSelectionInfo(client.getAccountName(), client.getSessionId().playOkID1);
        client.getConnection().sendPacket((SendablePacket)cl);
        client.setCharSelection(cl.getCharInfo());
        if (Config.DEBUG) {
            _log.fine("Character init end");
        }
    }

    public void startTutorialQuest(L2PcInstance player) {
        QuestState qs = player.getQuestState("255_Tutorial");
        Quest q = null;
        if (qs == null) {
            q = QuestManager.getInstance().getQuest("255_Tutorial");
        }
        if (q != null) {
            q.newQuestState(player).setState((byte)1);
        }
    }

    @Override
    public String getType() {
        return _C__0B_CHARACTERCREATE;
    }
}

