/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;
import java.util.Collection;

public class AttackableKnownList
extends NpcKnownList {
    public AttackableKnownList(L2Attackable activeChar) {
        super(activeChar);
    }

    @Override
    public boolean removeKnownObject(L2Object object) {
        if (!super.removeKnownObject(object)) {
            return false;
        }
        if (object instanceof L2Character) {
            this.getActiveChar().getAggroList().remove((Object)object);
        }
        Collection<L2PcInstance> known = this.getKnownPlayers().values();
        L2CharacterAI ai = this.getActiveChar().getAI();
        if (ai != null && (known == null || known.isEmpty())) {
            ai.setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
        return true;
    }

    @Override
    public L2Attackable getActiveChar() {
        return (L2Attackable)super.getActiveChar();
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        if (this.getActiveChar().getAggroList().get((Object)object) != null) {
            return 3000;
        }
        return Math.min(2200, 2 * this.getDistanceToWatchObject(object));
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (object instanceof L2NpcInstance || !(object instanceof L2Character)) {
            return 0;
        }
        if (object instanceof L2Playable) {
            return 1500;
        }
        if (this.getActiveChar().getAggroRange() > this.getActiveChar().getFactionRange()) {
            return this.getActiveChar().getAggroRange();
        }
        if (this.getActiveChar().getFactionRange() > 300) {
            return this.getActiveChar().getFactionRange();
        }
        return 300;
    }
}

