/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Calendar;
import java.util.StringTokenizer;

public final class L2TeleporterInstance
extends L2Npc {
    private static final int COND_ALL_FALSE = 0;
    private static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    private static final int COND_OWNER = 2;
    private static final int COND_REGULAR = 3;

    public L2TeleporterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TeleporterInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        int condition = this.validateCondition(player);
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        if (actualCommand.equalsIgnoreCase("goto")) {
            int npcId = this.getNpcId();
            switch (npcId) {
                case 32534: 
                case 32539: {
                    if (!player.isFlyingMounted()) break;
                    player.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_ENTER_SEED_IN_FLYING_TRANSFORM));
                    return;
                }
            }
            if (st.countTokens() <= 0) {
                return;
            }
            int whereTo = Integer.parseInt(st.nextToken());
            if (condition == 3) {
                this.doTeleport(player, whereTo);
                return;
            }
            if (condition == 2) {
                int minPrivilegeLevel = 0;
                if (st.countTokens() >= 1) {
                    minPrivilegeLevel = Integer.parseInt(st.nextToken());
                }
                if (10 >= minPrivilegeLevel) {
                    this.doTeleport(player, whereTo);
                } else {
                    player.sendMessage("You don't have the sufficient access level to teleport there.");
                }
                return;
            }
        } else if (command.startsWith("Chat")) {
            Calendar cal = Calendar.getInstance();
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (val == 1 && player.getLevel() < 41) {
                this.showNewbieHtml(player);
                return;
            }
            if (val == 1 && cal.get(11) >= 20 && cal.get(11) <= 23 && (cal.get(7) == 1 || cal.get(7) == 7)) {
                this.showHalfPriceHtml(player);
                return;
            }
            this.showChatWindow(player, val);
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/teleporter/", npcId, val);
    }

    private void showNewbieHtml(L2PcInstance player) {
        if (player == null) {
            return;
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        String filename = "data/html/teleporter/free/" + this.getTemplate().npcId + ".htm";
        if (HtmCache.getInstance().getHtm(player.getHtmlPrefix(), filename) == null) {
            filename = "data/html/teleporter/" + this.getTemplate().npcId + "-1.htm";
        }
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void showHalfPriceHtml(L2PcInstance player) {
        if (player == null) {
            return;
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        String filename = "data/html/teleporter/half/" + this.getNpcId() + ".htm";
        if (HtmCache.getInstance().getHtm(player.getHtmlPrefix(), filename) == null) {
            filename = "data/html/teleporter/" + this.getNpcId() + "-1.htm";
        }
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        String filename = "data/html/teleporter/castleteleporter-no.htm";
        int condition = this.validateCondition(player);
        if (condition == 3) {
            super.showChatWindow(player);
            return;
        }
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/teleporter/castleteleporter-busy.htm";
            } else if (condition == 2) {
                filename = this.getHtmlPath(this.getNpcId(), 0);
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list = TeleportLocationTable.getInstance().getTemplate(val);
        if (list != null) {
            if (SiegeManager.getInstance().getSiege(list.getLocX(), list.getLocY(), list.getLocZ()) != null) {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_PORT_THAT_IS_IN_SIGE));
                return;
            }
            if (TownManager.townHasCastleInSiege(list.getLocX(), list.getLocY()) && this.isInsideZone((byte)15)) {
                player.sendPacket(new SystemMessage(SystemMessageId.NO_PORT_THAT_IS_IN_SIGE));
                return;
            }
            if (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_GK && player.getKarma() > 0) {
                player.sendMessage("Go away, you're not welcome here.");
                return;
            }
            if (player.isCombatFlagEquipped()) {
                player.sendMessage("You can't port with a Combat Flag or Territory Ward!");
                return;
            }
            if (list.getIsForNoble() && !player.isNoble()) {
                String filename = "data/html/teleporter/nobleteleporter-no.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                html.replace((CharSequence)"%npcname%", this.getName());
                player.sendPacket(html);
                return;
            }
            if (player.isAlikeDead()) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            int price = list.getPrice();
            if (player.getLevel() < 41) {
                price = 0;
            } else if (!(list.getIsForNoble() || cal.get(11) < 20 || cal.get(11) > 23 || cal.get(7) != 1 && cal.get(7) != 7)) {
                price /= 2;
            }
            if (val == 0) {
                player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
            } else if (!list.getIsForNoble() && (Config.ALT_GAME_FREE_TELEPORT || player.reduceAdena("Teleport", price, this, true))) {
                if (Config.DEBUG) {
                    _log.fine("Teleporting player " + player.getName() + " to new location: " + list.getLocX() + ":" + list.getLocY() + ":" + list.getLocZ());
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ(), true);
            } else if (list.getIsForNoble() && (Config.ALT_GAME_FREE_TELEPORT || player.destroyItemByItemId("Noble Teleport", 13722, list.getPrice(), this, true))) {
                if (Config.DEBUG) {
                    _log.fine("Teleporting player " + player.getName() + " to new location: " + list.getLocX() + ":" + list.getLocY() + ":" + list.getLocZ());
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ(), true);
            }
        } else {
            _log.warning("No teleport destination with id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    private int validateCondition(L2PcInstance player) {
        if (CastleManager.getInstance().getCastleIndex(this) < 0) {
            return 3;
        }
        if (this.getCastle().getSiege().getIsInProgress()) {
            return 1;
        }
        if (player.getClan() != null && this.getCastle().getOwnerId() == player.getClanId()) {
            return 2;
        }
        return 0;
    }
}

