/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SortedWareHouseWithdrawalList;
import com.l2jserver.gameserver.network.serverpackets.WareHouseDepositList;
import com.l2jserver.gameserver.network.serverpackets.WareHouseWithdrawalList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;

public class L2FortManagerInstance
extends L2MerchantInstance {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;

    public L2FortManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2FortManagerInstance);
    }

    @Override
    public boolean isWarehouse() {
        return true;
    }

    private void sendHtmlMessage(L2PcInstance player, NpcHtmlMessage html) {
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getNpcId());
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            return;
        }
        if (condition == 1) {
            return;
        }
        if (condition == 2) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("expel")) {
                if ((player.getClanPrivileges() & 0x100000) == 0x100000) {
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-expel.htm");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-noprivs.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("banish_foreigner")) {
                if ((player.getClanPrivileges() & 0x100000) == 0x100000) {
                    this.getFort().banishForeigners();
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-expeled.htm");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-noprivs.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("receive_report")) {
                if (this.getFort().getFortState() < 2) {
                    SimpleDateFormat format2 = new SimpleDateFormat("HH");
                    SimpleDateFormat format3 = new SimpleDateFormat("mm");
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-report.htm");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    html.replace((CharSequence)"%hr%", format2.format(this.getFort().getOwnedTime()));
                    html.replace((CharSequence)"%min%", format3.format(this.getFort().getOwnedTime()));
                    player.sendPacket(html);
                    return;
                }
                SimpleDateFormat format2 = new SimpleDateFormat("HH");
                SimpleDateFormat format3 = new SimpleDateFormat("mm");
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-report.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                html.replace((CharSequence)"%hr%", format2.format(this.getFort().getOwnedTime()));
                html.replace((CharSequence)"%min%", format3.format(this.getFort().getOwnedTime()));
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("operate_door")) {
                if ((player.getClanPrivileges() & 0x10000) == 65536) {
                    if (!val.isEmpty()) {
                        boolean open;
                        boolean bl = open = Integer.parseInt(val) == 1;
                        while (st.hasMoreTokens()) {
                            this.getFort().openCloseDoor(player, Integer.parseInt(st.nextToken()), open);
                        }
                        if (open) {
                            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-opened.htm");
                            html.replace((CharSequence)"%objectId%", this.getObjectId());
                            player.sendPacket(html);
                            return;
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-closed.htm");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                        return;
                    }
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/" + this.getTemplate().npcId + "-d.htm");
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    html.replace((CharSequence)"%npcname%", this.getName());
                    player.sendPacket(html);
                    return;
                }
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-noprivs.htm");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage_vault")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                if ((player.getClanPrivileges() & 8) == 8) {
                    if (val.equalsIgnoreCase("deposit")) {
                        this.showVaultWindowDeposit(player);
                    } else if (val.equalsIgnoreCase("withdraw")) {
                        if (Config.L2JMOD_ENABLE_WAREHOUSESORTING_CLAN) {
                            String htmFile = "data/html/mods/WhSortedC.htm";
                            String htmContent = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), htmFile);
                            if (htmContent != null) {
                                NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
                                npcHtmlMessage.setHtml(htmContent);
                                npcHtmlMessage.replace((CharSequence)"%objectId%", this.getObjectId());
                                player.sendPacket(npcHtmlMessage);
                            } else {
                                _log.warning("Missing htm: " + htmFile + " !");
                            }
                        } else {
                            this.showVaultWindowWithdraw(player, null, (byte)0);
                        }
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-vault.htm");
                        this.sendHtmlMessage(player, html);
                    }
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-noprivs.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.startsWith("WithdrawSortedC")) {
                String[] param = command.split("_");
                if (param.length > 2) {
                    this.showVaultWindowWithdraw(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), SortedWareHouseWithdrawalList.getOrder(param[2]));
                } else if (param.length > 1) {
                    this.showVaultWindowWithdraw(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), (byte)1);
                } else {
                    this.showVaultWindowWithdraw(player, SortedWareHouseWithdrawalList.WarehouseListType.ALL, (byte)1);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("functions")) {
                if (val.equalsIgnoreCase("tele")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    if (this.getFort().getFunction(1) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/" + this.getNpcId() + "-t" + this.getFort().getFunction(1).getLvl() + ".htm");
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("support")) {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    if (this.getFort().getFunction(5) == null) {
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-nac.htm");
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/support" + this.getFort().getFunction(5).getLvl() + ".htm");
                        html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                    }
                    this.sendHtmlMessage(player, html);
                } else if (val.equalsIgnoreCase("back")) {
                    this.showChatWindow(player);
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-functions.htm");
                    if (this.getFort().getFunction(4) != null) {
                        html.replace((CharSequence)"%xp_regen%", this.getFort().getFunction(4).getLvl());
                    } else {
                        html.replace((CharSequence)"%xp_regen%", "0");
                    }
                    if (this.getFort().getFunction(2) != null) {
                        html.replace((CharSequence)"%hp_regen%", this.getFort().getFunction(2).getLvl());
                    } else {
                        html.replace((CharSequence)"%hp_regen%", "0");
                    }
                    if (this.getFort().getFunction(3) != null) {
                        html.replace((CharSequence)"%mp_regen%", this.getFort().getFunction(3).getLvl());
                    } else {
                        html.replace((CharSequence)"%mp_regen%", "0");
                    }
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("manage")) {
                if ((player.getClanPrivileges() & 0x800000) == 0x800000) {
                    if (val.equalsIgnoreCase("recovery")) {
                        if (st.countTokens() >= 1) {
                            if (this.getFort().getOwnerClan() == null) {
                                player.sendMessage("This fortress have no owner, you cannot change configuration");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("hp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery hp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("mp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery mp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("exp_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "recovery exp 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_hp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "(HP Recovery Device)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 300: {
                                        cost = Config.FS_HPREG1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.FS_HPREG2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.FS_HPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Provides additional HP recovery for clan members in the fortress.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace((CharSequence)"%apply%", "recovery hp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_mp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "(MP Recovery)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 40: {
                                        cost = Config.FS_MPREG1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.FS_MPREG2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.FS_MPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Provides additional MP recovery for clan members in the fortress.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace((CharSequence)"%apply%", "recovery mp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_exp")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "(EXP Recovery Device)");
                                int percent = Integer.parseInt(val);
                                switch (percent) {
                                    case 45: {
                                        cost = Config.FS_EXPREG1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.FS_EXPREG2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.FS_EXPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Restores the Exp of any clan member who is resurrected in the fortress.<font color=\"00FFFF\">" + percent + "%</font>");
                                html.replace((CharSequence)"%apply%", "recovery exp " + percent);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("hp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply_confirmed.htm");
                                    if (this.getFort().getFunction(2) != null && this.getFort().getFunction(2).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 300: {
                                            fee = Config.FS_HPREG1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.FS_HPREG2_FEE;
                                        }
                                    }
                                    if (!this.getFort().updateFunctions(player, 2, percent, fee, Config.FS_HPREG_FEE_RATIO, this.getFort().getFunction(2) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("mp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Mp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply_confirmed.htm");
                                    if (this.getFort().getFunction(3) != null && this.getFort().getFunction(3).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 40: {
                                            fee = Config.FS_MPREG1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.FS_MPREG2_FEE;
                                        }
                                    }
                                    if (!this.getFort().updateFunctions(player, 3, percent, fee, Config.FS_MPREG_FEE_RATIO, this.getFort().getFunction(3) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("exp")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Exp editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply_confirmed.htm");
                                    if (this.getFort().getFunction(4) != null && this.getFort().getFunction(4).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-used.htm");
                                        html.replace((CharSequence)"%val%", val + "%");
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int percent = Integer.parseInt(val);
                                    switch (percent) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 45: {
                                            fee = Config.FS_EXPREG1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.FS_EXPREG2_FEE;
                                        }
                                    }
                                    if (!this.getFort().updateFunctions(player, 4, percent, fee, Config.FS_EXPREG_FEE_RATIO, this.getFort().getFunction(4) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/edit_recovery.htm");
                        String hp = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 300\">300%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_hp 400\">400%</a>]";
                        String exp = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 45\">45%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_exp 50\">50%</a>]";
                        String mp = "[<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 40\">40%</a>][<a action=\"bypass -h npc_%objectId%_manage recovery edit_mp 50\">50%</a>]";
                        if (this.getFort().getFunction(2) != null) {
                            html.replace((CharSequence)"%hp_recovery%", this.getFort().getFunction(2).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getFort().getFunction(2).getLease() + "</font>Adena /" + Config.FS_HPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%hp_period%", "Withdraw the fee for the next time at " + format.format(this.getFort().getFunction(2).getEndTime()));
                            html.replace((CharSequence)"%change_hp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery hp_cancel\">Deactivate</a>]" + hp);
                        } else {
                            html.replace((CharSequence)"%hp_recovery%", "none");
                            html.replace((CharSequence)"%hp_period%", "none");
                            html.replace((CharSequence)"%change_hp%", hp);
                        }
                        if (this.getFort().getFunction(4) != null) {
                            html.replace((CharSequence)"%exp_recovery%", this.getFort().getFunction(4).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getFort().getFunction(4).getLease() + "</font>Adena /" + Config.FS_EXPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%exp_period%", "Withdraw the fee for the next time at " + format.format(this.getFort().getFunction(4).getEndTime()));
                            html.replace((CharSequence)"%change_exp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery exp_cancel\">Deactivate</a>]" + exp);
                        } else {
                            html.replace((CharSequence)"%exp_recovery%", "none");
                            html.replace((CharSequence)"%exp_period%", "none");
                            html.replace((CharSequence)"%change_exp%", exp);
                        }
                        if (this.getFort().getFunction(3) != null) {
                            html.replace((CharSequence)"%mp_recovery%", this.getFort().getFunction(3).getLvl() + "%</font> (<font color=\"FFAABB\">" + this.getFort().getFunction(3).getLease() + "</font>Adena /" + Config.FS_MPREG_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%mp_period%", "Withdraw the fee for the next time at " + format.format(this.getFort().getFunction(3).getEndTime()));
                            html.replace((CharSequence)"%change_mp%", "[<a action=\"bypass -h npc_%objectId%_manage recovery mp_cancel\">Deactivate</a>]" + mp);
                        } else {
                            html.replace((CharSequence)"%mp_recovery%", "none");
                            html.replace((CharSequence)"%mp_period%", "none");
                            html.replace((CharSequence)"%change_mp%", mp);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("other")) {
                        if (st.countTokens() >= 1) {
                            if (this.getFort().getOwnerClan() == null) {
                                player.sendMessage("This fortress have no owner, you cannot change configuration");
                                return;
                            }
                            val = st.nextToken();
                            if (val.equalsIgnoreCase("tele_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other tele 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("support_cancel")) {
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel.htm");
                                html.replace((CharSequence)"%apply%", "other support 0");
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_support")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Insignia (Supplementary Magic)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.FS_SUPPORT1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.FS_SUPPORT2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.FS_SUPPORT_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Enables the use of supplementary magic.");
                                html.replace((CharSequence)"%apply%", "other support " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("edit_tele")) {
                                int cost;
                                val = st.nextToken();
                                NpcHtmlMessage html = new NpcHtmlMessage(1);
                                html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply.htm");
                                html.replace((CharSequence)"%name%", "Mirror (Teleportation Device)");
                                int stage = Integer.parseInt(val);
                                switch (stage) {
                                    case 1: {
                                        cost = Config.FS_TELE1_FEE;
                                        break;
                                    }
                                    default: {
                                        cost = Config.FS_TELE2_FEE;
                                    }
                                }
                                html.replace((CharSequence)"%cost%", cost + "</font>Adena /" + Config.FS_TELE_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day</font>)");
                                html.replace((CharSequence)"%use%", "Teleports clan members in a fort to the target <font color=\"00FFFF\">Stage " + stage + "</font> staging area");
                                html.replace((CharSequence)"%apply%", "other tele " + stage);
                                this.sendHtmlMessage(player, html);
                                return;
                            }
                            if (val.equalsIgnoreCase("tele")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Tele editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply_confirmed.htm");
                                    if (this.getFort().getFunction(1) != null && this.getFort().getFunction(1).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-used.htm");
                                        html.replace((CharSequence)"%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.FS_TELE1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.FS_TELE2_FEE;
                                        }
                                    }
                                    if (!this.getFort().updateFunctions(player, 1, lvl, fee, Config.FS_TELE_FEE_RATIO, this.getFort().getFunction(1) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    }
                                    this.sendHtmlMessage(player, html);
                                }
                                return;
                            }
                            if (val.equalsIgnoreCase("support")) {
                                if (st.countTokens() >= 1) {
                                    int fee;
                                    if (Config.DEBUG) {
                                        _log.warning("Support editing invoked");
                                    }
                                    val = st.nextToken();
                                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-apply_confirmed.htm");
                                    if (this.getFort().getFunction(5) != null && this.getFort().getFunction(5).getLvl() == Integer.parseInt(val)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-used.htm");
                                        html.replace((CharSequence)"%val%", "Stage " + val);
                                        this.sendHtmlMessage(player, html);
                                        return;
                                    }
                                    int lvl = Integer.parseInt(val);
                                    switch (lvl) {
                                        case 0: {
                                            fee = 0;
                                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/functions-cancel_confirmed.htm");
                                            break;
                                        }
                                        case 1: {
                                            fee = Config.FS_SUPPORT1_FEE;
                                            break;
                                        }
                                        default: {
                                            fee = Config.FS_SUPPORT2_FEE;
                                        }
                                    }
                                    if (!this.getFort().updateFunctions(player, 5, lvl, fee, Config.FS_SUPPORT_FEE_RATIO, this.getFort().getFunction(5) == null)) {
                                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/low_adena.htm");
                                        this.sendHtmlMessage(player, html);
                                    } else {
                                        this.sendHtmlMessage(player, html);
                                    }
                                }
                                return;
                            }
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/edit_other.htm");
                        String tele = "[<a action=\"bypass -h npc_%objectId%_manage other edit_tele 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_tele 2\">Level 2</a>]";
                        String support = "[<a action=\"bypass -h npc_%objectId%_manage other edit_support 1\">Level 1</a>][<a action=\"bypass -h npc_%objectId%_manage other edit_support 2\">Level 2</a>]";
                        if (this.getFort().getFunction(1) != null) {
                            html.replace((CharSequence)"%tele%", "Stage " + this.getFort().getFunction(1).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getFort().getFunction(1).getLease() + "</font>Adena /" + Config.FS_TELE_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%tele_period%", "Withdraw the fee for the next time at " + format.format(this.getFort().getFunction(1).getEndTime()));
                            html.replace((CharSequence)"%change_tele%", "[<a action=\"bypass -h npc_%objectId%_manage other tele_cancel\">Deactivate</a>]" + tele);
                        } else {
                            html.replace((CharSequence)"%tele%", "none");
                            html.replace((CharSequence)"%tele_period%", "none");
                            html.replace((CharSequence)"%change_tele%", tele);
                        }
                        if (this.getFort().getFunction(5) != null) {
                            html.replace((CharSequence)"%support%", "Stage " + this.getFort().getFunction(5).getLvl() + "</font> (<font color=\"FFAABB\">" + this.getFort().getFunction(5).getLease() + "</font>Adena /" + Config.FS_SUPPORT_FEE_RATIO / 1000L / 60L / 60L / 24L + " Day)");
                            html.replace((CharSequence)"%support_period%", "Withdraw the fee for the next time at " + format.format(this.getFort().getFunction(5).getEndTime()));
                            html.replace((CharSequence)"%change_support%", "[<a action=\"bypass -h npc_%objectId%_manage other support_cancel\">Deactivate</a>]" + support);
                        } else {
                            html.replace((CharSequence)"%support%", "none");
                            html.replace((CharSequence)"%support_period%", "none");
                            html.replace((CharSequence)"%change_support%", support);
                        }
                        this.sendHtmlMessage(player, html);
                    } else if (val.equalsIgnoreCase("back")) {
                        this.showChatWindow(player);
                    } else {
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/manage.htm");
                        this.sendHtmlMessage(player, html);
                    }
                } else {
                    NpcHtmlMessage html = new NpcHtmlMessage(1);
                    html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-noprivs.htm");
                    this.sendHtmlMessage(player, html);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("support")) {
                this.setTarget(player);
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int skill_id = Integer.parseInt(val);
                    try {
                        L2Skill skill;
                        if (this.getFort().getFunction(5) == null) {
                            return;
                        }
                        if (this.getFort().getFunction(5).getLvl() == 0) {
                            return;
                        }
                        NpcHtmlMessage html = new NpcHtmlMessage(1);
                        int skill_lvl = 0;
                        if (st.countTokens() >= 1) {
                            skill_lvl = Integer.parseInt(st.nextToken());
                        }
                        if ((skill = SkillTable.getInstance().getInfo(skill_id, skill_lvl)).getSkillType() == L2SkillType.SUMMON) {
                            player.doCast(skill);
                        } else if (!((double)(skill.getMpConsume() + skill.getMpInitialConsume()) > this.getCurrentMp())) {
                            this.doCast(skill);
                        } else {
                            html.setFile(player.getHtmlPrefix(), "data/html/fortress/support-no_mana.htm");
                            html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                            this.sendHtmlMessage(player, html);
                            return;
                        }
                        html.setFile(player.getHtmlPrefix(), "data/html/fortress/support-done.htm");
                        html.replace((CharSequence)"%mp%", (int)this.getCurrentMp());
                        this.sendHtmlMessage(player, html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid skill level, contact your admin!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid skill level, contact your admin!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("support_back")) {
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                if (this.getFort().getFunction(5).getLvl() == 0) {
                    return;
                }
                html.setFile(player.getHtmlPrefix(), "data/html/fortress/support" + this.getFort().getFunction(5).getLvl() + ".htm");
                html.replace((CharSequence)"%mp%", (int)this.getStatus().getCurrentMp());
                this.sendHtmlMessage(player, html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("goto")) {
                int whereTo = Integer.parseInt(val);
                this.doTeleport(player, whereTo);
                return;
            }
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/fortress/foreman-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/fortress/foreman-busy.htm";
            } else if (condition == 2) {
                filename = "data/html/fortress/foreman.htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list;
        if (Config.DEBUG) {
            _log.warning("doTeleport(L2PcInstance player, int val) is called");
        }
        if ((list = TeleportLocationTable.getInstance().getTemplate(val)) != null) {
            if (player.reduceAdena("Teleport", list.getPrice(), this, true)) {
                if (Config.DEBUG) {
                    _log.warning("Teleporting player " + player.getName() + " for Fortress to new location: " + list.getLocX() + ":" + list.getLocY() + ":" + list.getLocZ());
                }
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ());
            }
        } else {
            _log.warning("No teleport destination with id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    protected int validateCondition(L2PcInstance player) {
        if (this.getFort() != null && this.getFort().getFortId() > 0 && player.getClan() != null) {
            if (this.getFort().getZone().isActive()) {
                return 1;
            }
            if (this.getFort().getOwnerClan() != null && this.getFort().getOwnerClan().getClanId() == player.getClanId()) {
                return 2;
            }
        }
        return 0;
    }

    private void showVaultWindowDeposit(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        player.setActiveWarehouse(player.getClan().getWarehouse());
        player.sendPacket(new WareHouseDepositList(player, 4));
    }

    private void showVaultWindowWithdraw(L2PcInstance player, SortedWareHouseWithdrawalList.WarehouseListType itemtype, byte sortorder) {
        if (player.isClanLeader() || (player.getClanPrivileges() & 8) == 8) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            player.setActiveWarehouse(player.getClan().getWarehouse());
            if (itemtype != null) {
                player.sendPacket(new SortedWareHouseWithdrawalList(player, 4, itemtype, sortorder));
            } else {
                player.sendPacket(new WareHouseWithdrawalList(player, 4));
            }
        } else {
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            html.setFile(player.getHtmlPrefix(), "data/html/fortress/foreman-noprivs.htm");
            this.sendHtmlMessage(player, html);
        }
    }
}

