/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GmListTable;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.util.Point3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class L2World {
    private static Logger _log = Logger.getLogger(L2World.class.getName());
    public static final int SHIFT_BY = 12;
    public static final int MAP_MIN_X = Config.WORLD_X_MIN - 20 << 15;
    public static final int MAP_MAX_X = Config.WORLD_X_MAX - 19 << 15;
    public static final int MAP_MIN_Y = Config.WORLD_Y_MIN - 18 << 15;
    public static final int MAP_MAX_Y = Config.WORLD_Y_MAX - 17 << 15;
    public static final int WORLD_SIZE_X = Config.WORLD_X_MAX - Config.WORLD_X_MIN + 1;
    public static final int WORLD_SIZE_Y = Config.WORLD_Y_MAX - Config.WORLD_Y_MIN + 1;
    public static final int OFFSET_X = Math.abs(MAP_MIN_X >> 12);
    public static final int OFFSET_Y = Math.abs(MAP_MIN_Y >> 12);
    private static final int REGIONS_X = (MAP_MAX_X >> 12) + OFFSET_X;
    private static final int REGIONS_Y = (MAP_MAX_Y >> 12) + OFFSET_Y;
    private Map<Integer, L2PcInstance> _allPlayers = new FastMap().shared();
    private Map<Integer, L2Object> _allObjects;
    private Map<Integer, L2PetInstance> _petsInstance = new FastMap().shared();
    private L2WorldRegion[][] _worldRegions;

    private L2World() {
        this._allObjects = new FastMap().shared();
        this.initRegions();
    }

    public static L2World getInstance() {
        return SingletonHolder._instance;
    }

    public void storeObject(L2Object object) {
        assert (!this._allObjects.containsKey(object.getObjectId()));
        if (this._allObjects.containsKey(object.getObjectId())) {
            if (Config.DEBUG) {
                _log.warning("[L2World] objectId " + object.getObjectId() + " already exist in OID map!");
            }
            return;
        }
        this._allObjects.put(object.getObjectId(), object);
    }

    public long timeStoreObject(L2Object object) {
        long time = System.currentTimeMillis();
        this._allObjects.put(object.getObjectId(), object);
        return time -= System.currentTimeMillis();
    }

    public void removeObject(L2Object object) {
        this._allObjects.remove(object.getObjectId());
    }

    public void removeObjects(List<L2Object> list) {
        for (L2Object o : list) {
            if (o == null) continue;
            this._allObjects.remove(o.getObjectId());
        }
    }

    public void removeObjects(L2Object[] objects) {
        for (L2Object o : objects) {
            this._allObjects.remove(o.getObjectId());
        }
    }

    public long timeRemoveObject(L2Object object) {
        long time = System.currentTimeMillis();
        this._allObjects.remove(object.getObjectId());
        return time -= System.currentTimeMillis();
    }

    public L2Object findObject(int oID) {
        return this._allObjects.get(oID);
    }

    public long timeFindObject(int objectID) {
        long time = System.currentTimeMillis();
        this._allObjects.get(objectID);
        return time -= System.currentTimeMillis();
    }

    @Deprecated
    public final Map<Integer, L2Object> getAllVisibleObjects() {
        return this._allObjects;
    }

    public final int getAllVisibleObjectsCount() {
        return this._allObjects.size();
    }

    public FastList<L2PcInstance> getAllGMs() {
        return GmListTable.getInstance().getAllGms(true);
    }

    public Map<Integer, L2PcInstance> getAllPlayers() {
        return this._allPlayers;
    }

    public int getAllPlayersCount() {
        return this._allPlayers.size();
    }

    public L2PcInstance getPlayer(String name) {
        return this.getPlayer(CharNameTable.getInstance().getIdByName(name));
    }

    public L2PcInstance getPlayer(int playerObjId) {
        return this._allPlayers.get(playerObjId);
    }

    public L2PetInstance getPet(int ownerId) {
        return this._petsInstance.get(ownerId);
    }

    public L2PetInstance addPet(int ownerId, L2PetInstance pet) {
        return this._petsInstance.put(ownerId, pet);
    }

    public void removePet(int ownerId) {
        this._petsInstance.remove(ownerId);
    }

    public void removePet(L2PetInstance pet) {
        this._petsInstance.remove(pet.getOwner().getObjectId());
    }

    public void addVisibleObject(L2Object object, L2WorldRegion newRegion) {
        L2PcInstance player;
        if (object instanceof L2PcInstance && !(player = (L2PcInstance)object).isTeleporting()) {
            L2PcInstance tmp = this._allPlayers.get(player.getObjectId());
            if (tmp != null) {
                _log.warning("Duplicate character!? Closing both characters (" + player.getName() + ")");
                player.logout();
                tmp.logout();
                return;
            }
            this._allPlayers.put(player.getObjectId(), player);
        }
        if (!newRegion.isActive().booleanValue()) {
            return;
        }
        List<L2Object> visibles = this.getVisibleObjects(object, 2000);
        if (Config.DEBUG) {
            _log.finest("objects in range:" + visibles.size());
        }
        for (L2Object visible : visibles) {
            visible.getKnownList().addKnownObject(object);
            object.getKnownList().addKnownObject(visible);
        }
    }

    public void addToAllPlayers(L2PcInstance cha) {
        this._allPlayers.put(cha.getObjectId(), cha);
    }

    public void removeFromAllPlayers(L2PcInstance cha) {
        this._allPlayers.remove(cha.getObjectId());
    }

    public void removeVisibleObject(L2Object object, L2WorldRegion oldRegion) {
        if (object == null) {
            return;
        }
        if (oldRegion != null) {
            oldRegion.removeVisibleObject(object);
            for (L2WorldRegion reg : oldRegion.getSurroundingRegions()) {
                Collection<L2Object> vObj = reg.getVisibleObjects().values();
                for (L2Object obj : vObj) {
                    if (obj.getKnownList() != null) {
                        obj.getKnownList().removeKnownObject(object);
                    }
                    if (object.getKnownList() == null) continue;
                    object.getKnownList().removeKnownObject(obj);
                }
            }
            object.getKnownList().removeAllKnownObjects();
            if (object instanceof L2PcInstance && !((L2PcInstance)object).isTeleporting()) {
                this.removeFromAllPlayers((L2PcInstance)object);
            }
        }
    }

    public List<L2Object> getVisibleObjects(L2Object object) {
        L2WorldRegion reg = object.getWorldRegion();
        if (reg == null) {
            return null;
        }
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        for (L2WorldRegion regi : reg.getSurroundingRegions()) {
            Collection<L2Object> vObj = regi.getVisibleObjects().values();
            for (L2Object _object : vObj) {
                if (_object.equals(object) || !_object.isVisible()) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public List<L2Object> getVisibleObjects(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return new ArrayList<L2Object>();
        }
        int x = object.getX();
        int y = object.getY();
        int sqRadius = radius * radius;
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            Collection<L2Object> vObj = regi.getVisibleObjects().values();
            for (L2Object _object : vObj) {
                int y1;
                double dy;
                int x1;
                double dx;
                if (_object.equals(object) || !((dx = (double)((x1 = _object.getX()) - x)) * dx + (dy = (double)((y1 = _object.getY()) - y)) * dy < (double)sqRadius)) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public List<L2Object> getVisibleObjects3D(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return new ArrayList<L2Object>();
        }
        int x = object.getX();
        int y = object.getY();
        int z = object.getZ();
        int sqRadius = radius * radius;
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            Collection<L2Object> vObj = regi.getVisibleObjects().values();
            for (L2Object _object : vObj) {
                int z1;
                long dz;
                int y1;
                long dy;
                int x1;
                long dx;
                if (_object.equals(object) || (dx = (long)((x1 = _object.getX()) - x)) * dx + (dy = (long)((y1 = _object.getY()) - y)) * dy + (dz = (long)((z1 = _object.getZ()) - z)) * dz >= (long)sqRadius) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public List<L2Playable> getVisiblePlayable(L2Object object) {
        L2WorldRegion reg = object.getWorldRegion();
        if (reg == null) {
            return null;
        }
        ArrayList<L2Playable> result = new ArrayList<L2Playable>();
        for (L2WorldRegion regi : reg.getSurroundingRegions()) {
            Map<Integer, L2Playable> _allpls = regi.getVisiblePlayable();
            Collection<L2Playable> _playables = _allpls.values();
            for (L2Playable _object : _playables) {
                if (_object.equals(object) || !_object.isVisible()) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public L2WorldRegion getRegion(Point3D point) {
        return this._worldRegions[(point.getX() >> 12) + OFFSET_X][(point.getY() >> 12) + OFFSET_Y];
    }

    public L2WorldRegion getRegion(int x, int y) {
        return this._worldRegions[(x >> 12) + OFFSET_X][(y >> 12) + OFFSET_Y];
    }

    public L2WorldRegion[][] getAllWorldRegions() {
        return this._worldRegions;
    }

    private boolean validRegion(int x, int y) {
        return x >= 0 && x <= REGIONS_X && y >= 0 && y <= REGIONS_Y;
    }

    private void initRegions() {
        _log.config("L2World: Setting up World Regions");
        this._worldRegions = new L2WorldRegion[REGIONS_X + 1][REGIONS_Y + 1];
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j] = new L2WorldRegion(i, j);
            }
        }
        for (int x = 0; x <= REGIONS_X; ++x) {
            for (int y = 0; y <= REGIONS_Y; ++y) {
                for (int a = -1; a <= 1; ++a) {
                    for (int b = -1; b <= 1; ++b) {
                        if (!this.validRegion(x + a, y + b)) continue;
                        this._worldRegions[x + a][y + b].addSurroundingRegion(this._worldRegions[x][y]);
                    }
                }
            }
        }
        _log.config("L2World: (" + REGIONS_X + " by " + REGIONS_Y + ") World Region Grid set up.");
    }

    public void deleteVisibleNpcSpawns() {
        _log.info("Deleting all visible NPC's.");
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j].deleteVisibleNpcSpawns();
            }
        }
        _log.info("All visible NPC's deleted.");
    }

    private static class SingletonHolder {
        protected static final L2World _instance = new L2World();

        private SingletonHolder() {
        }
    }
}

