/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

public abstract class L2Transformation
implements Cloneable,
Runnable {
    private final int _id;
    private final int _graphicalId;
    private double _collisionRadius;
    private double _collisionHeight;
    private final boolean _isStance;
    public static final int TRANSFORM_ZARICHE = 301;
    public static final int TRANSFORM_AKAMANAH = 302;
    protected static final int[] EMPTY_ARRAY = new int[0];
    private L2PcInstance _player;

    public L2Transformation(int id, int graphicalId, double collisionRadius, double collisionHeight) {
        this._id = id;
        this._graphicalId = graphicalId;
        this._collisionRadius = collisionRadius;
        this._collisionHeight = collisionHeight;
        this._isStance = false;
    }

    public L2Transformation(int id, double collisionRadius, double collisionHeight) {
        this(id, id, collisionRadius, collisionHeight);
    }

    public L2Transformation(int id) {
        this._id = id;
        this._graphicalId = id;
        this._isStance = true;
    }

    public int getId() {
        return this._id;
    }

    public int getGraphicalId() {
        return this._graphicalId;
    }

    public boolean isStance() {
        return this._isStance;
    }

    public double getCollisionRadius() {
        if (this.isStance()) {
            return this._player.getCollisionRadius();
        }
        return this._collisionRadius;
    }

    public double getCollisionHeight() {
        if (this.isStance()) {
            return this._player.getCollisionHeight();
        }
        return this._collisionHeight;
    }

    public abstract void onTransform();

    public abstract void onUntransform();

    private void setPlayer(L2PcInstance player) {
        this._player = player;
    }

    public L2PcInstance getPlayer() {
        return this._player;
    }

    public void start() {
        this.resume();
    }

    public void resume() {
        this.getPlayer().transform(this);
    }

    @Override
    public void run() {
        this.stop();
    }

    public void stop() {
        this.getPlayer().untransform();
    }

    public L2Transformation createTransformationForPlayer(L2PcInstance player) {
        try {
            L2Transformation transformation = (L2Transformation)this.clone();
            transformation.setPlayer(player);
            return transformation;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void onLevelUp() {
    }

    public boolean canDoMeleeAttack() {
        return true;
    }

    public boolean canStartFollowToCast() {
        return true;
    }
}

