/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.templates.item.L2Item;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class L2TradeList {
    private Map<Integer, L2TradeItem> _items = new FastMap();
    private int _listId;
    private String _buystorename;
    private String _sellstorename;
    private boolean _hasLimitedStockItem;
    private String _npcId;

    public L2TradeList(int listId) {
        this._listId = listId;
    }

    public void setNpcId(String id) {
        this._npcId = id;
    }

    public String getNpcId() {
        return this._npcId;
    }

    public void addItem(L2TradeItem item) {
        this._items.put(item.getItemId(), item);
        if (item.hasLimitedStock()) {
            this.setHasLimitedStockItem(true);
        }
    }

    public void replaceItem(int itemID, long price) {
        L2TradeItem item = this._items.get(itemID);
        if (item != null) {
            item.setPrice(price);
        }
    }

    public void removeItem(int itemID) {
        this._items.remove(itemID);
    }

    public int getListId() {
        return this._listId;
    }

    public void setHasLimitedStockItem(boolean hasLimitedStockItem) {
        this._hasLimitedStockItem = hasLimitedStockItem;
    }

    public boolean hasLimitedStockItem() {
        return this._hasLimitedStockItem;
    }

    public void setSellStoreName(String name) {
        this._sellstorename = name;
    }

    public String getSellStoreName() {
        return this._sellstorename;
    }

    public void setBuyStoreName(String name) {
        this._buystorename = name;
    }

    public String getBuyStoreName() {
        return this._buystorename;
    }

    public Collection<L2TradeItem> getItems() {
        return this._items.values();
    }

    public List<L2TradeItem> getItems(int start, int end) {
        LinkedList<L2TradeItem> list = new LinkedList<L2TradeItem>();
        list.addAll(this._items.values());
        return list.subList(start, end);
    }

    public long getPriceForItemId(int itemId) {
        L2TradeItem item = this._items.get(itemId);
        if (item != null) {
            return item.getPrice();
        }
        return -1L;
    }

    public L2TradeItem getItemById(int itemId) {
        return this._items.get(itemId);
    }

    public boolean containsItemId(int itemId) {
        return this._items.containsKey(itemId);
    }

    public static class L2TradeItem {
        private static final Logger _log = Logger.getLogger(L2TradeItem.class.getName());
        private final int _listId;
        private final int _itemId;
        private final L2Item _template;
        private long _price;
        private AtomicLong _currentCount = new AtomicLong();
        private long _maxCount = -1L;
        private long _restoreDelay;
        private long _nextRestoreTime;

        public L2TradeItem(int listId, int itemId) {
            this._listId = listId;
            this._itemId = itemId;
            this._template = ItemTable.getInstance().getTemplate(itemId);
        }

        public int getItemId() {
            return this._itemId;
        }

        public void setPrice(long price) {
            this._price = price;
        }

        public long getPrice() {
            return this._price;
        }

        public L2Item getTemplate() {
            return this._template;
        }

        public void setCurrentCount(long currentCount) {
            this._currentCount.set(currentCount);
        }

        public boolean decreaseCount(long val) {
            return this._currentCount.addAndGet(-val) >= 0L;
        }

        public long getCurrentCount() {
            long ret;
            if (this.hasLimitedStock() && this.isPendingStockUpdate()) {
                this.restoreInitialCount();
            }
            return (ret = this._currentCount.get()) > 0L ? ret : 0L;
        }

        public boolean isPendingStockUpdate() {
            return System.currentTimeMillis() >= this._nextRestoreTime;
        }

        public void restoreInitialCount() {
            this.setCurrentCount(this.getMaxCount());
            this._nextRestoreTime += this.getRestoreDelay();
            if (this.isPendingStockUpdate() && this.getRestoreDelay() > 0L) {
                this._nextRestoreTime = System.currentTimeMillis() + this.getRestoreDelay();
            }
            try {
                ThreadPoolManager.getInstance().executeTask(new TimerSave());
            }
            catch (RejectedExecutionException e) {
                this.saveDataTimer();
            }
        }

        public void setMaxCount(long maxCount) {
            this._maxCount = maxCount;
        }

        public long getMaxCount() {
            return this._maxCount;
        }

        public boolean hasLimitedStock() {
            return this.getMaxCount() > -1L;
        }

        public void setRestoreDelay(long restoreDelay) {
            this._restoreDelay = restoreDelay * 60L * 60L * 1000L;
        }

        public long getRestoreDelay() {
            return this._restoreDelay;
        }

        public void setNextRestoreTime(long nextRestoreTime) {
            this._nextRestoreTime = nextRestoreTime;
        }

        public long getNextRestoreTime() {
            return this._nextRestoreTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void saveDataTimer() {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("UPDATE merchant_buylists SET savetimer =? WHERE shop_id =? and item_id =?");
                statement.setLong(1, this._nextRestoreTime);
                statement.setInt(2, this._listId);
                statement.setInt(3, this._itemId);
                statement.executeUpdate();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "L2TradeItem: Could not update Timer save in Buylist");
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }

        class TimerSave
        implements Runnable {
            TimerSave() {
            }

            @Override
            public void run() {
                L2TradeItem.this.saveDataTimer();
            }
        }
    }
}

