/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.MultiSellList;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class L2Multisell {
    private static Logger _log = Logger.getLogger(L2Multisell.class.getName());
    private List<MultiSellListContainer> _entries = new FastList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiSellListContainer getList(int id) {
        List<MultiSellListContainer> list = this._entries;
        synchronized (list) {
            for (MultiSellListContainer list2 : this._entries) {
                if (list2.getListId() != id) continue;
                return list2;
            }
        }
        _log.warning("[L2Multisell] can't find list with id: " + id);
        return null;
    }

    private L2Multisell() {
        this.parseData();
    }

    public void reload() {
        this.parseData();
    }

    public static L2Multisell getInstance() {
        return SingletonHolder._instance;
    }

    private void parseData() {
        this._entries.clear();
        this.parse();
        _log.config("L2Multisell: Loaded " + this._entries.size() + " lists.");
    }

    private MultiSellListContainer generateMultiSell(int listId, boolean inventoryOnly, L2PcInstance player, int npcId, double taxRate) {
        MultiSellListContainer listTemplate = L2Multisell.getInstance().getList(listId);
        MultiSellListContainer list = new MultiSellListContainer();
        if (listTemplate == null) {
            return list;
        }
        list = L2Multisell.getInstance().new MultiSellListContainer();
        list.setListId(listId);
        if (npcId != 0 && !listTemplate.checkNpcId(npcId)) {
            listTemplate.addNpcId(npcId);
        }
        if (inventoryOnly) {
            if (player == null) {
                return list;
            }
            L2ItemInstance[] items = listTemplate.getMaintainEnchantment() ? player.getInventory().getUniqueItemsByEnchantLevel(false, false, false) : player.getInventory().getUniqueItems(false, false, false);
            for (L2ItemInstance item : items) {
                int enchantLevel;
                if (item.isEquipped() || !(item.getItem() instanceof L2Armor) && !(item.getItem() instanceof L2Weapon)) continue;
                int n = enchantLevel = listTemplate.getMaintainEnchantment() ? item.getEnchantLevel() : 0;
                int augmentId = listTemplate.getMaintainEnchantment() ? (item.getAugmentation() != null ? item.getAugmentation().getAugmentationId() : 0) : 0;
                int elementId = listTemplate.getMaintainEnchantment() ? (int)item.getAttackElementType() : -2;
                int elementValue = listTemplate.getMaintainEnchantment() ? item.getAttackElementPower() : 0;
                int fireVal = listTemplate.getMaintainEnchantment() ? item.getElementDefAttr((byte)0) : 0;
                int waterVal = listTemplate.getMaintainEnchantment() ? item.getElementDefAttr((byte)1) : 0;
                int windVal = listTemplate.getMaintainEnchantment() ? item.getElementDefAttr((byte)2) : 0;
                int earthVal = listTemplate.getMaintainEnchantment() ? item.getElementDefAttr((byte)3) : 0;
                int holyVal = listTemplate.getMaintainEnchantment() ? item.getElementDefAttr((byte)4) : 0;
                int darkVal = listTemplate.getMaintainEnchantment() ? item.getElementDefAttr((byte)5) : 0;
                for (MultiSellEntry ent : listTemplate.getEntries()) {
                    boolean doInclude = false;
                    for (MultiSellIngredient ing : ent.getIngredients()) {
                        if (item.getItemId() != ing.getItemId()) continue;
                        doInclude = true;
                        break;
                    }
                    if (!doInclude) continue;
                    list.addEntry(this.prepareEntry(ent, listTemplate.getApplyTaxes(), listTemplate.getMaintainEnchantment(), enchantLevel, augmentId, elementId, elementValue, fireVal, waterVal, windVal, earthVal, holyVal, darkVal, taxRate));
                }
            }
        } else {
            for (MultiSellEntry ent : listTemplate.getEntries()) {
                list.addEntry(this.prepareEntry(ent, listTemplate.getApplyTaxes(), false, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, taxRate));
            }
        }
        return list;
    }

    private MultiSellEntry prepareEntry(MultiSellEntry templateEntry, boolean applyTaxes, boolean maintainEnchantment, int enchantLevel, int augmentId, int elementId, int elementValue, int fireValue, int waterValue, int windValue, int earthValue, int holyValue, int darkValue, double taxRate) {
        L2Item tempItem;
        MultiSellIngredient newIngredient;
        MultiSellEntry newEntry = L2Multisell.getInstance().new MultiSellEntry();
        newEntry.setEntryId(templateEntry.getEntryId() * 100000 + enchantLevel);
        long adenaAmount = 0L;
        for (MultiSellIngredient ing : templateEntry.getIngredients()) {
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            newIngredient = l2Multisell.new MultiSellIngredient(ing);
            if (ing.getItemId() == 57 && ing.isTaxIngredient()) {
                if (!applyTaxes) continue;
                adenaAmount += Math.round((double)ing.getItemCount() * taxRate);
                continue;
            }
            if (ing.getItemId() == 57) {
                adenaAmount += ing.getItemCount();
                continue;
            }
            if (maintainEnchantment && newIngredient.getItemId() > 0 && ((tempItem = ItemTable.getInstance().createDummyItem(ing.getItemId()).getItem()) instanceof L2Armor || tempItem instanceof L2Weapon)) {
                newIngredient.setEnchantmentLevel(enchantLevel);
                newIngredient.setAugmentId(augmentId);
                newIngredient.setElementId(elementId);
                newIngredient.setElementValue(elementValue);
                newIngredient.setFireValue(fireValue);
                newIngredient.setWaterValue(waterValue);
                newIngredient.setWindValue(windValue);
                newIngredient.setEarthValue(earthValue);
                newIngredient.setHolyValue(holyValue);
                newIngredient.setDarkValue(darkValue);
            }
            newEntry.addIngredient(newIngredient);
        }
        if (adenaAmount > 0L) {
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            newEntry.addIngredient(l2Multisell.new MultiSellIngredient(57, adenaAmount, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, false, false));
        }
        for (MultiSellIngredient ing : templateEntry.getProducts()) {
            L2Multisell l2Multisell = L2Multisell.getInstance();
            l2Multisell.getClass();
            newIngredient = l2Multisell.new MultiSellIngredient(ing);
            if (maintainEnchantment && ((tempItem = ItemTable.getInstance().createDummyItem(ing.getItemId()).getItem()) instanceof L2Armor || tempItem instanceof L2Weapon)) {
                newIngredient.setEnchantmentLevel(enchantLevel);
                newIngredient.setAugmentId(augmentId);
                newIngredient.setElementId(elementId);
                newIngredient.setElementValue(elementValue);
                newIngredient.setFireValue(fireValue);
                newIngredient.setWaterValue(waterValue);
                newIngredient.setWindValue(windValue);
                newIngredient.setEarthValue(earthValue);
                newIngredient.setHolyValue(holyValue);
                newIngredient.setDarkValue(darkValue);
            }
            newEntry.addProduct(newIngredient);
        }
        return newEntry;
    }

    public void separateAndSend(int listId, L2PcInstance player, int npcId, boolean inventoryOnly, double taxRate) {
        MultiSellListContainer list = this.generateMultiSell(listId, inventoryOnly, player, npcId, taxRate);
        MultiSellListContainer temp = new MultiSellListContainer();
        int page = 1;
        temp.setListId(list.getListId());
        for (MultiSellEntry e : list.getEntries()) {
            if (temp.getEntries().size() == 40) {
                player.sendPacket(new MultiSellList(temp, page++, 0));
                temp = new MultiSellListContainer();
                temp.setListId(list.getListId());
            }
            temp.addEntry(e);
        }
        player.sendPacket(new MultiSellList(temp, page, 1));
    }

    private void hashFiles(String dirname, List<File> hash) {
        File[] files;
        File dir = new File(Config.DATAPACK_ROOT, "data/" + dirname);
        if (!dir.exists()) {
            _log.config("Dir " + dir.getAbsolutePath() + " not exists");
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            hash.add(f);
        }
    }

    private void parse() {
        Document doc = null;
        int id = 0;
        FastList files = new FastList();
        this.hashFiles("multisell", (List<File>)files);
        for (File f : files) {
            try {
                id = Integer.parseInt(f.getName().replaceAll(".xml", ""));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                doc = factory.newDocumentBuilder().parse(f);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error loading file " + f, e);
                continue;
            }
            try {
                MultiSellListContainer list = this.parseDocument(doc);
                list.setListId(id);
                this._entries.add(list);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error in file " + f, e);
            }
        }
    }

    protected MultiSellListContainer parseDocument(Document doc) {
        MultiSellListContainer list = new MultiSellListContainer();
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                Node attribute = n.getAttributes().getNamedItem("applyTaxes");
                if (attribute == null) {
                    list.setApplyTaxes(false);
                } else {
                    list.setApplyTaxes(Boolean.parseBoolean(attribute.getNodeValue()));
                }
                attribute = n.getAttributes().getNamedItem("maintainEnchantment");
                if (attribute == null) {
                    list.setMaintainEnchantment(false);
                } else {
                    list.setMaintainEnchantment(Boolean.parseBoolean(attribute.getNodeValue()));
                }
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    MultiSellEntry e = this.parseEntry(d);
                    list.addEntry(e);
                }
                continue;
            }
            if (!"item".equalsIgnoreCase(n.getNodeName())) continue;
            MultiSellEntry e = this.parseEntry(n);
            list.addEntry(e);
        }
        return list;
    }

    protected MultiSellEntry parseEntry(Node n) {
        int entryId = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
        Node first = n.getFirstChild();
        MultiSellEntry entry = new MultiSellEntry();
        for (n = first; n != null; n = n.getNextSibling()) {
            if ("ingredient".equalsIgnoreCase(n.getNodeName())) {
                int id = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
                long count = Long.parseLong(n.getAttributes().getNamedItem("count").getNodeValue());
                boolean isTaxIngredient = false;
                boolean mantainIngredient = false;
                Node attribute = n.getAttributes().getNamedItem("isTaxIngredient");
                if (attribute != null) {
                    isTaxIngredient = Boolean.parseBoolean(attribute.getNodeValue());
                }
                if ((attribute = n.getAttributes().getNamedItem("mantainIngredient")) != null) {
                    mantainIngredient = Boolean.parseBoolean(attribute.getNodeValue());
                }
                MultiSellIngredient e = new MultiSellIngredient(id, count, isTaxIngredient, mantainIngredient);
                entry.addIngredient(e);
                continue;
            }
            if (!"production".equalsIgnoreCase(n.getNodeName())) continue;
            int id = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
            long count = Long.parseLong(n.getAttributes().getNamedItem("count").getNodeValue());
            MultiSellIngredient e = new MultiSellIngredient(id, count, false, false);
            entry.addProduct(e);
        }
        entry.setEntryId(entryId);
        return entry;
    }

    private static class SingletonHolder {
        protected static final L2Multisell _instance = new L2Multisell();

        private SingletonHolder() {
        }
    }

    public class MultiSellListContainer {
        private int _listId;
        private boolean _applyTaxes = false;
        private boolean _maintainEnchantment = false;
        private List<Integer> _npcIds;
        List<MultiSellEntry> _entriesC = new FastList();

        public void setListId(int listId) {
            this._listId = listId;
        }

        public void setApplyTaxes(boolean applyTaxes) {
            this._applyTaxes = applyTaxes;
        }

        public void setMaintainEnchantment(boolean maintainEnchantment) {
            this._maintainEnchantment = maintainEnchantment;
        }

        public void addNpcId(int objId) {
            this._npcIds.add(objId);
        }

        public int getListId() {
            return this._listId;
        }

        public boolean getApplyTaxes() {
            return this._applyTaxes;
        }

        public boolean getMaintainEnchantment() {
            return this._maintainEnchantment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean checkNpcId(int npcId) {
            if (this._npcIds == null) {
                MultiSellListContainer multiSellListContainer = this;
                synchronized (multiSellListContainer) {
                    if (this._npcIds == null) {
                        this._npcIds = new FastList();
                    }
                }
                return false;
            }
            return this._npcIds.contains(npcId);
        }

        public void addEntry(MultiSellEntry e) {
            this._entriesC.add(e);
        }

        public List<MultiSellEntry> getEntries() {
            return this._entriesC;
        }
    }

    public class MultiSellIngredient {
        private int _itemId;
        private int _enchantmentLevel;
        private int _element;
        private int _elementVal;
        private int _augment;
        private int _fireVal;
        private int _waterVal;
        private int _windVal;
        private int _earthVal;
        private int _holyVal;
        private int _darkVal;
        private long _itemCount;
        private boolean _isTaxIngredient;
        private boolean _mantainIngredient;

        public MultiSellIngredient(int itemId, long itemCount, boolean isTaxIngredient, boolean mantainIngredient) {
            this(itemId, itemCount, 0, 0, -2, 0, 0, 0, 0, 0, 0, 0, isTaxIngredient, mantainIngredient);
        }

        public MultiSellIngredient(int itemId, long itemCount, int enchantmentLevel, int augmentId, int elementId, int elementVal, int fireVal, int waterVal, int windVal, int earthVal, int holyVal, int darkVal, boolean isTaxIngredient, boolean mantainIngredient) {
            this.setItemId(itemId);
            this.setItemCount(itemCount);
            this.setEnchantmentLevel(enchantmentLevel);
            this.setAugmentId(augmentId);
            this.setElementId(elementId);
            this.setElementValue(elementVal);
            this.setFireValue(fireVal);
            this.setWaterValue(waterVal);
            this.setWindValue(windVal);
            this.setEarthValue(earthVal);
            this.setHolyValue(holyVal);
            this.setDarkValue(darkVal);
            this.setIsTaxIngredient(isTaxIngredient);
            this.setMantainIngredient(mantainIngredient);
        }

        public MultiSellIngredient(MultiSellIngredient e) {
            this._itemId = e.getItemId();
            this._itemCount = e.getItemCount();
            this._enchantmentLevel = e.getEnchantmentLevel();
            this._isTaxIngredient = e.isTaxIngredient();
            this._mantainIngredient = e.getMantainIngredient();
            this._augment = e.getAugmentId();
            this._element = e.getElementId();
            this._elementVal = e.getElementVal();
            this._fireVal = e.getFireVal();
            this._waterVal = e.getWaterVal();
            this._windVal = e.getWindVal();
            this._earthVal = e.getEarthVal();
            this._holyVal = e.getHolyVal();
            this._darkVal = e.getDarkVal();
        }

        public void setAugmentId(int augment) {
            this._augment = augment;
        }

        public void setElementId(int element) {
            this._element = element;
        }

        public void setElementValue(int elementVal) {
            this._elementVal = elementVal;
        }

        public void setFireValue(int val) {
            this._fireVal = val;
        }

        public void setWaterValue(int val) {
            this._waterVal = val;
        }

        public void setWindValue(int val) {
            this._windVal = val;
        }

        public void setEarthValue(int val) {
            this._earthVal = val;
        }

        public void setHolyValue(int val) {
            this._holyVal = val;
        }

        public void setDarkValue(int val) {
            this._darkVal = val;
        }

        public int getAugmentId() {
            return this._augment;
        }

        public int getElementId() {
            return this._element;
        }

        public int getElementVal() {
            return this._elementVal;
        }

        public int getFireVal() {
            return this._fireVal;
        }

        public int getWaterVal() {
            return this._waterVal;
        }

        public int getWindVal() {
            return this._windVal;
        }

        public int getEarthVal() {
            return this._earthVal;
        }

        public int getHolyVal() {
            return this._holyVal;
        }

        public int getDarkVal() {
            return this._darkVal;
        }

        public void setItemId(int itemId) {
            this._itemId = itemId;
        }

        public int getItemId() {
            return this._itemId;
        }

        public void setItemCount(long itemCount) {
            this._itemCount = itemCount;
        }

        public long getItemCount() {
            return this._itemCount;
        }

        public void setEnchantmentLevel(int enchantmentLevel) {
            this._enchantmentLevel = enchantmentLevel;
        }

        public int getEnchantmentLevel() {
            return this._enchantmentLevel;
        }

        public void setIsTaxIngredient(boolean isTaxIngredient) {
            this._isTaxIngredient = isTaxIngredient;
        }

        public boolean isTaxIngredient() {
            return this._isTaxIngredient;
        }

        public void setMantainIngredient(boolean mantainIngredient) {
            this._mantainIngredient = mantainIngredient;
        }

        public boolean getMantainIngredient() {
            return this._mantainIngredient;
        }
    }

    public class MultiSellEntry {
        private int _entryId;
        private List<MultiSellIngredient> _products = new FastList();
        private List<MultiSellIngredient> _ingredients = new FastList();

        public void setEntryId(int entryId) {
            this._entryId = entryId;
        }

        public int getEntryId() {
            return this._entryId;
        }

        public void addProduct(MultiSellIngredient product) {
            this._products.add(product);
        }

        public List<MultiSellIngredient> getProducts() {
            return this._products;
        }

        public void addIngredient(MultiSellIngredient ingredient) {
            this._ingredients.add(ingredient);
        }

        public List<MultiSellIngredient> getIngredients() {
            return this._ingredients;
        }

        public int stackable() {
            for (MultiSellIngredient p : this._products) {
                L2Item template;
                if (p.getItemId() <= 0 || (template = ItemTable.getInstance().getTemplate(p.getItemId())) == null || template.isStackable()) continue;
                return 0;
            }
            return 1;
        }
    }
}

