/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class RaidBossPointsManager {
    private static final Logger _log = Logger.getLogger(RaidBossPointsManager.class.getName());
    protected static FastMap<Integer, Map<Integer, Integer>> _list;
    private static final Comparator<Map.Entry<Integer, Integer>> _comparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void init() {
        _list = new FastMap();
        FastList _chars = new FastList();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM `character_raid_points`");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                _chars.add((Object)rset.getInt("charId"));
            }
            rset.close();
            statement.close();
            FastList.Node n = _chars.head();
            FastList.Node end = _chars.tail();
            while ((n = n.getNext()) != end) {
                int charId = (Integer)n.getValue();
                FastMap values = new FastMap();
                statement = con.prepareStatement("SELECT * FROM `character_raid_points` WHERE `charId`=?");
                statement.setInt(1, charId);
                rset = statement.executeQuery();
                while (rset.next()) {
                    values.put((Object)rset.getInt("boss_id"), (Object)rset.getInt("points"));
                }
                rset.close();
                statement.close();
                _list.put((Object)charId, (Object)values);
            }
        }
        catch (SQLException e) {
            _log.warning("RaidPointsManager: Couldnt load raid points ");
        }
        catch (Exception e) {
            _log.warning(e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                _log.warning(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void updatePointsInDB(L2PcInstance player, int raidId, int points) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("REPLACE INTO character_raid_points (`charId`,`boss_id`,`points`) VALUES (?,?,?)");
            statement.setInt(1, player.getObjectId());
            statement.setInt(2, raidId);
            statement.setInt(3, points);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not update char raid points:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public static final void addPoints(L2PcInstance player, int bossId, int points) {
        Map tmpPoint;
        int ownerId = player.getObjectId();
        if (_list == null) {
            _list = new FastMap();
        }
        if ((tmpPoint = (Map)_list.get((Object)ownerId)) == null || tmpPoint.isEmpty()) {
            tmpPoint = new FastMap();
            tmpPoint.put(bossId, points);
            RaidBossPointsManager.updatePointsInDB(player, bossId, points);
        } else {
            int currentPoins = tmpPoint.containsKey(bossId) ? (Integer)tmpPoint.get(bossId) : 0;
            tmpPoint.remove(bossId);
            tmpPoint.put(bossId, currentPoins == 0 ? points : currentPoins + points);
            RaidBossPointsManager.updatePointsInDB(player, bossId, currentPoins == 0 ? points : currentPoins + points);
        }
        _list.remove((Object)ownerId);
        _list.put((Object)ownerId, (Object)tmpPoint);
    }

    public static final int getPointsByOwnerId(int ownerId) {
        if (_list == null) {
            _list = new FastMap();
        }
        Map tmpPoint = (Map)_list.get((Object)ownerId);
        int totalPoints = 0;
        if (tmpPoint == null || tmpPoint.isEmpty()) {
            return 0;
        }
        Iterator i$ = tmpPoint.keySet().iterator();
        while (i$.hasNext()) {
            int bossId = (Integer)i$.next();
            totalPoints += ((Integer)tmpPoint.get(bossId)).intValue();
        }
        return totalPoints;
    }

    public static final Map<Integer, Integer> getList(L2PcInstance player) {
        return (Map)_list.get((Object)player.getObjectId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cleanUp() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE from character_raid_points WHERE charId > 0");
            statement.executeUpdate();
            statement.close();
            _list.clear();
            _list = new FastMap();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not clean raid points: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public static final int calculateRanking(int playerObjId) {
        FastMap tmpRanking = new FastMap();
        FastMap tmpPoints = new FastMap();
        Iterator i$ = _list.keySet().iterator();
        while (i$.hasNext()) {
            int ownerId = (Integer)i$.next();
            int totalPoints = RaidBossPointsManager.getPointsByOwnerId(ownerId);
            if (totalPoints == 0) continue;
            tmpPoints.put(ownerId, totalPoints);
        }
        ArrayList list = new ArrayList(tmpPoints.entrySet());
        Collections.sort(list, _comparator);
        int ranking = 1;
        for (Map.Entry entry : list) {
            tmpRanking.put(entry.getKey(), ranking++);
        }
        if (tmpRanking.containsKey(playerObjId)) {
            return (Integer)tmpRanking.get(playerObjId);
        }
        return 0;
    }

    public static Map<Integer, Integer> getRankList() {
        FastMap tmpRanking = new FastMap();
        FastMap tmpPoints = new FastMap();
        Iterator i$ = _list.keySet().iterator();
        while (i$.hasNext()) {
            int ownerId = (Integer)i$.next();
            int totalPoints = RaidBossPointsManager.getPointsByOwnerId(ownerId);
            if (totalPoints == 0) continue;
            tmpPoints.put(ownerId, totalPoints);
        }
        ArrayList list = new ArrayList(tmpPoints.entrySet());
        Collections.sort(list, _comparator);
        int ranking = 1;
        for (Map.Entry entry : list) {
            tmpRanking.put(entry.getKey(), ranking++);
        }
        return tmpRanking;
    }

    static {
        _comparator = new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> entry, Map.Entry<Integer, Integer> entry1) {
                return entry.getValue().equals(entry1.getValue()) ? 0 : (entry.getValue() < entry1.getValue() ? 1 : -1);
            }
        };
    }
}

