/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DecoyInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.Die;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javolution.util.FastList;

public class FrintezzaManagerFinalBattle {
    private static Logger _log = Logger.getLogger(FrintezzaManagerFinalBattle.class.getName());
    private static FrintezzaManagerFinalBattle _instance;
    public final int ALIVE = 0;
    public final int FIGHTING = 1;
    public final int DEAD = 2;
    protected L2Npc weakScarlet;
    protected L2Npc strongScarlet;
    protected L2Npc frintezza;
    protected L2Npc portrait1;
    protected L2Npc portrait2;
    protected L2Npc portrait3;
    protected L2Npc portrait4;
    protected L2Npc dummy;
    protected L2Npc dummy1;
    protected L2Npc dummy2;
    protected L2Npc dummy3;
    protected L2Npc cube;
    protected L2BossZone _zone = GrandBossManager.getInstance().getZone(174250, -86969, -5116);
    protected boolean isMorphed = false;
    protected boolean isSecMorphed = false;
    protected L2Character _target;
    protected Future<?> _skillFrintezza;
    protected Future<?> _skillScarlet;
    protected Future<?> _retarget;
    protected Future<?> _clean;

    public static FrintezzaManagerFinalBattle getInstance() {
        if (_instance == null) {
            _log.info("Initializing FrintezzaManager TEST version");
            _instance = new FrintezzaManagerFinalBattle();
        }
        return _instance;
    }

    public FrintezzaManagerFinalBattle() {
        StatsSet set = GrandBossManager.getInstance().getStatsSet(29045);
        int status = GrandBossManager.getInstance().getBossStatus(29045);
        switch (status) {
            case 2: {
                long time = set.getLong("respawn_time") - System.currentTimeMillis();
                if (time > 0L) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new spawntask(), time);
                    break;
                }
                GrandBossManager.getInstance().setBossStatus(29045, 0);
            }
        }
    }

    public void startBattle() {
        this.frintezza = this.createNewSpawn(29045, 174240, -89805, -5022, 16048);
        this.frintezza.setIsImmobilized(true);
        ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(1), 1000L);
    }

    protected void doSecondMorph() {
        ThreadPoolManager.getInstance().scheduleGeneral(new secondMorph(1), 0L);
    }

    protected void doThirdMorph() {
        ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(1), 0L);
    }

    protected void doScarletDie() {
        ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(1), 0L);
    }

    protected L2Npc createNewSpawn(int templateId, int x, int y, int z, int heading) {
        L2Spawn tempSpawn = null;
        try {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(templateId);
            tempSpawn = new L2Spawn(template);
            tempSpawn.setLocx(x);
            tempSpawn.setLocy(y);
            tempSpawn.setLocz(z);
            tempSpawn.setHeading(heading);
            tempSpawn.setAmount(1);
            tempSpawn.stopRespawn();
            SpawnTable.getInstance().addNewSpawn(tempSpawn, false);
        }
        catch (Throwable t) {
            _log.warning(t.getMessage());
        }
        L2Npc npc = tempSpawn.doSpawn();
        return npc;
    }

    protected void specialcamera(L2Npc target, int dist, int yaw, int pitch, int time, int duration, int turn, int rise) {
        if (target == null) {
            return;
        }
        for (L2Character pc : this._zone.getCharactersInside().values()) {
            if (!(pc instanceof L2PcInstance)) continue;
            ((L2PcInstance)pc).abortAttack();
            ((L2PcInstance)pc).abortCast();
            ((L2PcInstance)pc).setTarget(null);
            ((L2PcInstance)pc).getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            ((L2PcInstance)pc).sendPacket(new SpecialCamera(target.getObjectId(), dist, yaw, pitch, time, duration, turn, rise, 1, 0));
        }
    }

    protected void social(L2Npc target, int action) {
        if (target == null) {
            return;
        }
        this._zone.broadcastPacket(new SocialAction(target.getObjectId(), action));
    }

    protected void cast(L2Npc npc, L2Skill skill) {
        if (npc == null) {
            return;
        }
        if (skill == null) {
            return;
        }
        this._zone.broadcastPacket(new MagicSkillUse(npc, npc, skill.getDisplayId(), skill.getLevel(), skill.getHitTime(), skill.getReuseDelay()));
    }

    protected void npcupdate() {
        for (L2Character pc : this._zone.getCharactersInside().values()) {
            if (!(pc instanceof L2PcInstance)) continue;
            ((L2PcInstance)pc).sendPacket(new AbstractNpcInfo.NpcInfo(this.weakScarlet, pc));
        }
    }

    protected L2Character getRandomTarget(L2Npc npc) {
        FastList result = new FastList();
        Collection<L2Object> objs = npc.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            if (obj instanceof L2Character && (!GeoData.getInstance().canSeeTarget(((L2Character)obj).getX(), ((L2Character)obj).getY(), ((L2Character)obj).getZ(), npc.getX(), npc.getY(), npc.getZ()) || ((L2Character)obj).isGM()) || !(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) && !(obj instanceof L2DecoyInstance) || !Util.checkIfInRange(9000, npc, obj, true) || ((L2Character)obj).isDead()) continue;
            result.add((Object)((L2Character)obj));
        }
        if (result.size() != 0) {
            Object[] characters = result.toArray();
            return (L2Character)characters[Rnd.get(characters.length)];
        }
        return null;
    }

    protected L2Skill getRandomSkill(L2Npc npc) {
        int lvl;
        int skill;
        L2Skill s = null;
        if (npc == this.weakScarlet) {
            if (!this.isMorphed) {
                if (Rnd.get(100) < 10) {
                    skill = 5016;
                    lvl = 1;
                } else if (Rnd.get(100) < 10) {
                    skill = 5016;
                    lvl = 1;
                } else if (Rnd.get(100) < 10) {
                    skill = 5015;
                    lvl = Rnd.get(1, 6);
                } else {
                    skill = 5014;
                    lvl = 1;
                }
                s = SkillTable.getInstance().getInfo(skill, lvl);
            } else if (this.isMorphed) {
                if (Rnd.get(100) < 10) {
                    skill = 5018;
                    lvl = 1;
                } else if (Rnd.get(100) < 10) {
                    skill = 5016;
                    lvl = 1;
                } else if (Rnd.get(100) < 10) {
                    skill = 5015;
                    lvl = Rnd.get(1, 6);
                } else {
                    skill = 5014;
                    lvl = 2;
                }
                s = SkillTable.getInstance().getInfo(skill, lvl);
            }
        }
        if (npc == this.strongScarlet) {
            if (Rnd.get(100) < 10) {
                skill = 5018;
                lvl = 2;
            } else if (Rnd.get(100) < 10) {
                skill = 5019;
                lvl = 1;
            } else if (Rnd.get(100) < 10) {
                skill = 5015;
                lvl = Rnd.get(1, 6);
            } else if (Rnd.get(100) < 10) {
                skill = 5016;
                lvl = 1;
            } else {
                skill = 5014;
                lvl = 3;
            }
            s = SkillTable.getInstance().getInfo(skill, lvl);
        }
        if (npc == this.frintezza) {
            if (Rnd.get(100) < 10) {
                skill = 5007;
                lvl = 1;
            } else if (Rnd.get(100) < 10) {
                skill = 5007;
                lvl = 2;
            } else if (Rnd.get(100) < 10) {
                skill = 5007;
                lvl = 3;
            } else if (Rnd.get(100) < 10) {
                skill = 5007;
                lvl = 4;
            } else if (Rnd.get(100) < 10) {
                skill = 5007;
                lvl = 5;
            } else {
                skill = 5006;
                lvl = 1;
            }
            s = SkillTable.getInstance().getInfo(skill, lvl);
        }
        return s;
    }

    protected synchronized void callSkillAI(L2Npc npc) {
        L2Skill _skill = null;
        if (npc.isInvul() || npc.isCastingNow()) {
            return;
        }
        if (this._target == null || this._target.isDead()) {
            this._target = this.getRandomTarget(npc);
            if (this._target != null) {
                _skill = this.getRandomSkill(npc);
            }
        }
        L2Character target = this._target;
        L2Skill skill = _skill;
        if (skill == null) {
            skill = this.getRandomSkill(npc);
        }
        if (target == null || target.isDead()) {
            npc.setIsCastingNow(false);
            return;
        }
        if (Util.checkIfInRange(skill.getCastRange(), npc, target, true)) {
            npc.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            npc.setTarget(target);
            npc.setIsCastingNow(true);
            this._target = null;
            _skill = null;
            npc.doCast(skill);
        } else {
            npc.setIsCastingNow(false);
        }
    }

    public void statuscheck(int id) {
        switch (id) {
            case 29046: {
                if (this.weakScarlet.getCurrentHp() <= (double)(this.weakScarlet.getMaxHp() * 2 / 3) && !this.isMorphed) {
                    this.isMorphed = true;
                    this.doSecondMorph();
                    break;
                }
                if (!(this.weakScarlet.getCurrentHp() <= (double)(this.weakScarlet.getMaxHp() * 1 / 3)) || !this.isMorphed || this.isSecMorphed) break;
                this.isSecMorphed = true;
                this.doThirdMorph();
            }
        }
    }

    public void onKill(int id) {
        switch (id) {
            case 29047: {
                this.doScarletDie();
            }
        }
    }

    public void clean() {
        this._zone.oustAllPlayers();
        this.isMorphed = false;
        this.isSecMorphed = false;
        if (this._skillFrintezza != null) {
            this._skillFrintezza.cancel(true);
        }
        if (this._skillScarlet != null) {
            this._skillScarlet.cancel(true);
        }
        if (this._retarget != null) {
            this._retarget.cancel(true);
        }
        if (this._clean != null) {
            this._clean.cancel(true);
        }
        if (this.weakScarlet != null) {
            this.weakScarlet.decayMe();
            this.weakScarlet.deleteMe();
            this.weakScarlet = null;
        }
        if (this.strongScarlet != null) {
            this.strongScarlet.decayMe();
            this.strongScarlet.deleteMe();
            this.strongScarlet = null;
        }
        if (this.frintezza != null) {
            this.frintezza.decayMe();
            this.frintezza.deleteMe();
            this.frintezza = null;
        }
        if (this.portrait1 != null) {
            this.portrait1.decayMe();
            this.portrait1.deleteMe();
            this.portrait1 = null;
        }
        if (this.portrait2 != null) {
            this.portrait2.decayMe();
            this.portrait2.deleteMe();
            this.portrait2 = null;
        }
        if (this.portrait3 != null) {
            this.portrait3.decayMe();
            this.portrait3.deleteMe();
            this.portrait3 = null;
        }
        if (this.portrait4 != null) {
            this.portrait4.decayMe();
            this.portrait4.deleteMe();
            this.portrait4 = null;
        }
        if (this.dummy != null) {
            this.dummy.decayMe();
            this.dummy.deleteMe();
            this.dummy = null;
        }
        if (this.dummy1 != null) {
            this.dummy1.decayMe();
            this.dummy1.deleteMe();
            this.dummy1 = null;
        }
        if (this.dummy3 != null) {
            this.dummy3.decayMe();
            this.dummy3.deleteMe();
            this.dummy3 = null;
        }
        if (this.cube != null) {
            this.cube.decayMe();
            this.cube.deleteMe();
            this.cube = null;
        }
    }

    private class check_pc
    implements Runnable {
        @Override
        public void run() {
            boolean d = false;
            for (L2Character cha : FrintezzaManagerFinalBattle.this._zone.getCharactersInside().values()) {
                if (!(cha instanceof L2PcInstance)) continue;
                d = true;
            }
            if (!d) {
                FrintezzaManagerFinalBattle.this.clean();
            } else {
                FrintezzaManagerFinalBattle.this._clean = ThreadPoolManager.getInstance().scheduleGeneral(new check_pc(), 300000L);
            }
        }
    }

    protected class cleantask
    implements Runnable {
        protected cleantask() {
        }

        @Override
        public void run() {
            FrintezzaManagerFinalBattle.this.clean();
        }
    }

    protected class spawntask
    implements Runnable {
        protected spawntask() {
        }

        @Override
        public void run() {
            GrandBossManager.getInstance().setBossStatus(29045, 0);
        }
    }

    protected class retarget
    implements Runnable {
        protected retarget() {
        }

        @Override
        public void run() {
            if (FrintezzaManagerFinalBattle.this.weakScarlet != null) {
                FrintezzaManagerFinalBattle.this._target = FrintezzaManagerFinalBattle.this.getRandomTarget(FrintezzaManagerFinalBattle.this.weakScarlet);
                ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).addDamageHate(FrintezzaManagerFinalBattle.this._target, 0, 9999);
                FrintezzaManagerFinalBattle.this.weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, FrintezzaManagerFinalBattle.this._target);
            }
            if (FrintezzaManagerFinalBattle.this.strongScarlet != null) {
                FrintezzaManagerFinalBattle.this._target = FrintezzaManagerFinalBattle.this.getRandomTarget(FrintezzaManagerFinalBattle.this.strongScarlet);
                ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.strongScarlet).addDamageHate(FrintezzaManagerFinalBattle.this._target, 0, 9999);
                FrintezzaManagerFinalBattle.this.strongScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, FrintezzaManagerFinalBattle.this._target);
            }
            FrintezzaManagerFinalBattle.this._retarget = ThreadPoolManager.getInstance().scheduleGeneral(this, 120000L);
        }
    }

    protected class frinteza
    implements Runnable {
        protected frinteza() {
        }

        @Override
        public void run() {
            L2Skill _skill = null;
            L2Skill skill = null;
            if (FrintezzaManagerFinalBattle.this.frintezza != null && !FrintezzaManagerFinalBattle.this.frintezza.isDead() && !FrintezzaManagerFinalBattle.this.frintezza.isCastingNow() && (_skill = FrintezzaManagerFinalBattle.this.getRandomSkill(FrintezzaManagerFinalBattle.this.frintezza)) != null) {
                FrintezzaManagerFinalBattle.this.frintezza.doCast(_skill);
                if (_skill.getId() == 5007 && (skill = SkillTable.getInstance().getInfo(5008, _skill.getLevel())) != null) {
                    if (FrintezzaManagerFinalBattle.this.weakScarlet != null && !FrintezzaManagerFinalBattle.this.weakScarlet.isDead()) {
                        FrintezzaManagerFinalBattle.this.weakScarlet.doCast(skill);
                    }
                    if (FrintezzaManagerFinalBattle.this.strongScarlet != null && !FrintezzaManagerFinalBattle.this.strongScarlet.isDead()) {
                        FrintezzaManagerFinalBattle.this.strongScarlet.doCast(skill);
                    }
                }
            }
            FrintezzaManagerFinalBattle.this._skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(this, 5000L);
        }
    }

    protected class strongscarlet
    implements Runnable {
        protected strongscarlet() {
        }

        @Override
        public void run() {
            FrintezzaManagerFinalBattle.this.callSkillAI(FrintezzaManagerFinalBattle.this.strongScarlet);
            FrintezzaManagerFinalBattle.this._skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(this, 30000L);
        }
    }

    protected class weakscarlet
    implements Runnable {
        protected weakscarlet() {
        }

        @Override
        public void run() {
            FrintezzaManagerFinalBattle.this.callSkillAI(FrintezzaManagerFinalBattle.this.weakScarlet);
            FrintezzaManagerFinalBattle.this._skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(this, 30000L);
        }
    }

    private class frintezzaIntro
    implements Runnable {
        private int _taskId = 0;

        public frintezzaIntro(int taskId) {
            this._taskId = taskId;
        }

        @Override
        public void run() {
            switch (this._taskId) {
                case 1: {
                    FrintezzaManagerFinalBattle.this.frintezza.setIsInvul(true);
                    FrintezzaManagerFinalBattle.this.frintezza.abortAttack();
                    FrintezzaManagerFinalBattle.this.frintezza.abortCast();
                    FrintezzaManagerFinalBattle.this.dummy3 = FrintezzaManagerFinalBattle.this.createNewSpawn(29052, 174232, -88023, -5115, 56847);
                    FrintezzaManagerFinalBattle.this.dummy3.setIsImmobilized(true);
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.dummy3, 30, -180, -20, 0, 4100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(2), 4000L);
                    break;
                }
                case 2: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.dummy3, 800, 90, -90, 6000, 6100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(3), 5000L);
                    break;
                }
                case 3: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 1500, 90, 10, 2000, 3000, 0, 0);
                    FrintezzaManagerFinalBattle.this.dummy3.deleteMe();
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(4), 2000L);
                    break;
                }
                case 4: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 200, 90, -10, 3000, 4100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(5), 4000L);
                    break;
                }
                case 5: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 100, 90, 25, 3000, 11000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(6), 4000L);
                    break;
                }
                case 6: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 80, 70, -10, 0, 11000, 0, 0);
                    FrintezzaManagerFinalBattle.this.social(FrintezzaManagerFinalBattle.this.frintezza, 1);
                    FrintezzaManagerFinalBattle.this.portrait3 = FrintezzaManagerFinalBattle.this.createNewSpawn(29050, 172608, -88702, -4972, 64817);
                    FrintezzaManagerFinalBattle.this.portrait4 = FrintezzaManagerFinalBattle.this.createNewSpawn(29051, 172634, -87165, -4972, 57730);
                    FrintezzaManagerFinalBattle.this.dummy = FrintezzaManagerFinalBattle.this.createNewSpawn(29053, 174228, -88019, -5122, 57730);
                    FrintezzaManagerFinalBattle.this.dummy.setIsImmobilized(true);
                    FrintezzaManagerFinalBattle.this.dummy2 = FrintezzaManagerFinalBattle.this.createNewSpawn(29053, 175493, -88744, -5108, 45719);
                    FrintezzaManagerFinalBattle.this.dummy2.setIsImmobilized(true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(7), 7000L);
                    break;
                }
                case 7: {
                    FrintezzaManagerFinalBattle.this.portrait1 = FrintezzaManagerFinalBattle.this.createNewSpawn(29050, 175833, -87165, -4972, 35048);
                    FrintezzaManagerFinalBattle.this.portrait2 = FrintezzaManagerFinalBattle.this.createNewSpawn(29051, 175876, -88713, -4972, 28205);
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.dummy2, 250, -55, 10, 0, 6000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(8), 1500L);
                    break;
                }
                case 8: {
                    FrintezzaManagerFinalBattle.this.social(FrintezzaManagerFinalBattle.this.portrait1, 1);
                    FrintezzaManagerFinalBattle.this.social(FrintezzaManagerFinalBattle.this.portrait2, 1);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(9), 4000L);
                    break;
                }
                case 9: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 200, 90, -10, 0, 10000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(99), 1000L);
                    break;
                }
                case 99: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 100, 90, 25, 5000, 10000, 0, 0);
                    FrintezzaManagerFinalBattle.this.social(FrintezzaManagerFinalBattle.this.frintezza, 3);
                    FrintezzaManagerFinalBattle.this.weakScarlet = FrintezzaManagerFinalBattle.this.createNewSpawn(29046, 174226, -88035, -5115, 42682);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(10), 5000L);
                    break;
                }
                case 10: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 10, 170, 40, 0, 10000, 0, 0);
                    FrintezzaManagerFinalBattle.this.frintezza.enableAllSkills();
                    L2Skill _skill = SkillTable.getInstance().getInfo(5006, 1);
                    FrintezzaManagerFinalBattle.this.cast(FrintezzaManagerFinalBattle.this.frintezza, _skill);
                    FrintezzaManagerFinalBattle.this.weakScarlet.deleteMe();
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(11), 5000L);
                    break;
                }
                case 11: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 1100, 160, 30, 4000, 4100, 0, 0);
                    FrintezzaManagerFinalBattle.this.dummy1 = FrintezzaManagerFinalBattle.this.createNewSpawn(29053, 173319, -88443, -3312, 48028);
                    FrintezzaManagerFinalBattle.this.dummy1.setIsImmobilized(true);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(12), 4000L);
                    break;
                }
                case 12: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 1600, 120, 30, 4000, 4100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(13), 4000L);
                    FrintezzaManagerFinalBattle.this.frintezza.setIsInvul(false);
                    break;
                }
                case 13: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.dummy1, 2100, 155, -45, 0, 6000, 0, 0);
                    L2Skill _skil = SkillTable.getInstance().getInfo(5004, 1);
                    FrintezzaManagerFinalBattle.this.cast(FrintezzaManagerFinalBattle.this.dummy, _skil);
                    FrintezzaManagerFinalBattle.this.frintezza.setIsInvul(false);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(14), 5000L);
                    break;
                }
                case 14: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.dummy, 500, 0, 30, 4000, 4300, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(15), 200L);
                    break;
                }
                case 15: {
                    FrintezzaManagerFinalBattle.this.weakScarlet = FrintezzaManagerFinalBattle.this.createNewSpawn(29046, 174226, -88035, -5115, 42682);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(16), 4000L);
                    break;
                }
                case 16: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.weakScarlet, 200, -90, 20, 4000, 5000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new frintezzaIntro(17), 5000L);
                    break;
                }
                case 17: {
                    FrintezzaManagerFinalBattle.this.dummy.decayMe();
                    FrintezzaManagerFinalBattle.this.dummy.deleteMe();
                    FrintezzaManagerFinalBattle.this.dummy1.decayMe();
                    FrintezzaManagerFinalBattle.this.dummy1.deleteMe();
                    L2Character s = FrintezzaManagerFinalBattle.this.getRandomTarget(FrintezzaManagerFinalBattle.this.weakScarlet);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).addDamageHate(s, 0, 9999);
                    FrintezzaManagerFinalBattle.this.weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, s);
                    FrintezzaManagerFinalBattle.this._skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(new frinteza(), 1000L);
                    FrintezzaManagerFinalBattle.this._retarget = ThreadPoolManager.getInstance().scheduleGeneral(new retarget(), 40000L);
                    FrintezzaManagerFinalBattle.this._skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(new weakscarlet(), 40000L);
                    FrintezzaManagerFinalBattle.this._clean = ThreadPoolManager.getInstance().scheduleGeneral(new check_pc(), 300000L);
                }
            }
        }
    }

    private class scarletDie
    implements Runnable {
        private int _taskId = 0;

        public scarletDie(int taskId) {
            this._taskId = taskId;
        }

        @Override
        public void run() {
            switch (this._taskId) {
                case 1: {
                    if (FrintezzaManagerFinalBattle.this._retarget != null) {
                        FrintezzaManagerFinalBattle.this._retarget.cancel(true);
                    }
                    if (FrintezzaManagerFinalBattle.this._skillScarlet != null) {
                        FrintezzaManagerFinalBattle.this._skillScarlet.cancel(true);
                    }
                    if (FrintezzaManagerFinalBattle.this._skillFrintezza != null) {
                        FrintezzaManagerFinalBattle.this._skillFrintezza.cancel(true);
                    }
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.strongScarlet, 500, 90, 80, 0, 10000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(2), 10000L);
                    break;
                }
                case 2: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 100, 120, 10, 0, 12000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(22), 2000L);
                    break;
                }
                case 22: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 100, 90, 30, 3000, 12000, 0, 0);
                    FrintezzaManagerFinalBattle.this.frintezza.doDie(FrintezzaManagerFinalBattle.this.frintezza);
                    FrintezzaManagerFinalBattle.this._zone.broadcastPacket(new Die(FrintezzaManagerFinalBattle.this.frintezza));
                    ThreadPoolManager.getInstance().scheduleGeneral(new scarletDie(3), 5000L);
                    break;
                }
                case 3: {
                    FrintezzaManagerFinalBattle.this.cube = FrintezzaManagerFinalBattle.this.createNewSpawn(29061, 174226, -88035, -5115, 42682);
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 1000, 90, 30, 4000, 6000, 0, 0);
                    GrandBossManager.getInstance().setBossStatus(29045, 2);
                    StatsSet set = GrandBossManager.getInstance().getStatsSet(29045);
                    set.set("respawn_time", System.currentTimeMillis() + 432000000L);
                    GrandBossManager.getInstance().setStatsSet(29045, set);
                    ThreadPoolManager.getInstance().scheduleGeneral(new spawntask(), 432000000L);
                    if (FrintezzaManagerFinalBattle.this._clean != null) {
                        FrintezzaManagerFinalBattle.this._clean.cancel(true);
                    }
                    ThreadPoolManager.getInstance().scheduleGeneral(new cleantask(), 900000L);
                }
            }
        }
    }

    private class thirdMorph
    implements Runnable {
        private int _taskId = 0;

        public thirdMorph(int taskId) {
            this._taskId = taskId;
        }

        @Override
        public void run() {
            switch (this._taskId) {
                case 1: {
                    if (FrintezzaManagerFinalBattle.this._retarget != null) {
                        FrintezzaManagerFinalBattle.this._retarget.cancel(true);
                    }
                    if (FrintezzaManagerFinalBattle.this._skillScarlet != null) {
                        FrintezzaManagerFinalBattle.this._skillScarlet.cancel(true);
                    }
                    if (FrintezzaManagerFinalBattle.this._skillFrintezza != null) {
                        FrintezzaManagerFinalBattle.this._skillFrintezza.cancel(true);
                    }
                    FrintezzaManagerFinalBattle.this.weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    FrintezzaManagerFinalBattle.this.weakScarlet.abortAttack();
                    FrintezzaManagerFinalBattle.this.weakScarlet.abortCast();
                    FrintezzaManagerFinalBattle.this.frintezza.breakCast();
                    L2Skill _skill = SkillTable.getInstance().getInfo(5007, 5);
                    FrintezzaManagerFinalBattle.this.cast(FrintezzaManagerFinalBattle.this.frintezza, _skill);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).disableCoreAI(true);
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 700, 120, 0, 0, 7000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(22), 1000L);
                    break;
                }
                case 22: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 100, 90, 0, 3000, 4100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(23), 4000L);
                    break;
                }
                case 23: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 100, 60, 0, 1000, 1100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(24), 1000L);
                    break;
                }
                case 24: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.frintezza, 1200, 90, 20, 7000, 7100, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(25), 7000L);
                    break;
                }
                case 25: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.weakScarlet, 400, 260, 30, 0, 7000, 0, 0);
                    FrintezzaManagerFinalBattle.this.weakScarlet.doDie(FrintezzaManagerFinalBattle.this.weakScarlet);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(2), 7000L);
                    break;
                }
                case 2: {
                    FrintezzaManagerFinalBattle.this.strongScarlet = FrintezzaManagerFinalBattle.this.createNewSpawn(29047, FrintezzaManagerFinalBattle.this.weakScarlet.getX(), FrintezzaManagerFinalBattle.this.weakScarlet.getY(), FrintezzaManagerFinalBattle.this.weakScarlet.getZ(), FrintezzaManagerFinalBattle.this.weakScarlet.getHeading());
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.strongScarlet, 200, 260, 30, 0, 9000, 0, 0);
                    FrintezzaManagerFinalBattle.this.weakScarlet.decayMe();
                    FrintezzaManagerFinalBattle.this.weakScarlet.deleteMe();
                    FrintezzaManagerFinalBattle.this.weakScarlet = null;
                    FrintezzaManagerFinalBattle.this.strongScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    FrintezzaManagerFinalBattle.this.strongScarlet.abortAttack();
                    FrintezzaManagerFinalBattle.this.strongScarlet.abortCast();
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(33), 1000L);
                    break;
                }
                case 33: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.strongScarlet, 200, 270, -10, 2000, 9000, 0, 0);
                    FrintezzaManagerFinalBattle.this.social(FrintezzaManagerFinalBattle.this.strongScarlet, 1);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(34), 2000L);
                    break;
                }
                case 34: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.strongScarlet, 200, 230, 0, 0, 9000, 0, 0);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(35), 1000L);
                    break;
                }
                case 35: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.strongScarlet, 200, 230, 0, 2000, 9000, 0, 20);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(3), 2000L);
                    break;
                }
                case 3: {
                    FrintezzaManagerFinalBattle.this.specialcamera(FrintezzaManagerFinalBattle.this.strongScarlet, 400, 250, 0, 2000, 4000, 0, 0);
                    FrintezzaManagerFinalBattle.this.social(FrintezzaManagerFinalBattle.this.strongScarlet, 2);
                    ThreadPoolManager.getInstance().scheduleGeneral(new thirdMorph(4), 4000L);
                    break;
                }
                case 4: {
                    L2Character s = FrintezzaManagerFinalBattle.this.getRandomTarget(FrintezzaManagerFinalBattle.this.strongScarlet);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.strongScarlet).addDamageHate(s, 0, 9999);
                    FrintezzaManagerFinalBattle.this.strongScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, s);
                    FrintezzaManagerFinalBattle.this._retarget = ThreadPoolManager.getInstance().scheduleGeneral(new retarget(), 1000L);
                    FrintezzaManagerFinalBattle.this._skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(new strongscarlet(), 10000L);
                    FrintezzaManagerFinalBattle.this._skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(new frinteza(), 1000L);
                }
            }
        }
    }

    private class secondMorph
    implements Runnable {
        private int _taskId = 0;

        public secondMorph(int taskId) {
            this._taskId = taskId;
        }

        @Override
        public void run() {
            switch (this._taskId) {
                case 1: {
                    if (FrintezzaManagerFinalBattle.this._retarget != null) {
                        FrintezzaManagerFinalBattle.this._retarget.cancel(true);
                    }
                    if (FrintezzaManagerFinalBattle.this._skillScarlet != null) {
                        FrintezzaManagerFinalBattle.this._skillScarlet.cancel(true);
                    }
                    if (FrintezzaManagerFinalBattle.this._skillFrintezza != null) {
                        FrintezzaManagerFinalBattle.this._skillFrintezza.cancel(true);
                    }
                    FrintezzaManagerFinalBattle.this.weakScarlet.setIsImmobilized(true);
                    FrintezzaManagerFinalBattle.this.weakScarlet.setIsInvul(true);
                    FrintezzaManagerFinalBattle.this.weakScarlet.abortAttack();
                    FrintezzaManagerFinalBattle.this.weakScarlet.abortCast();
                    FrintezzaManagerFinalBattle.this.weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).clearAggroList();
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).disableCoreAI(true);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).setTarget(null);
                    ThreadPoolManager.getInstance().scheduleGeneral(new secondMorph(2), 2000L);
                    break;
                }
                case 2: {
                    L2Skill _skill = SkillTable.getInstance().getInfo(5017, 1);
                    FrintezzaManagerFinalBattle.this.weakScarlet.doCast(_skill);
                    FrintezzaManagerFinalBattle.this.cast(FrintezzaManagerFinalBattle.this.weakScarlet, _skill);
                    ThreadPoolManager.getInstance().scheduleGeneral(new secondMorph(3), 6000L);
                    break;
                }
                case 3: {
                    FrintezzaManagerFinalBattle.this.weakScarlet.setIsImmobilized(false);
                    FrintezzaManagerFinalBattle.this.weakScarlet.setRHandId(7903);
                    FrintezzaManagerFinalBattle.this.npcupdate();
                    FrintezzaManagerFinalBattle.this.weakScarlet.getStatus().setCurrentHp(FrintezzaManagerFinalBattle.this.weakScarlet.getStatus().getCurrentHp() * 1.15);
                    FrintezzaManagerFinalBattle.this.weakScarlet.setIsInvul(false);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).disableCoreAI(false);
                    L2Character s = FrintezzaManagerFinalBattle.this.getRandomTarget(FrintezzaManagerFinalBattle.this.weakScarlet);
                    ((L2GrandBossInstance)FrintezzaManagerFinalBattle.this.weakScarlet).addDamageHate(s, 0, 9999);
                    FrintezzaManagerFinalBattle.this.weakScarlet.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, s);
                    FrintezzaManagerFinalBattle.this._retarget = ThreadPoolManager.getInstance().scheduleGeneral(new retarget(), 1000L);
                    FrintezzaManagerFinalBattle.this._skillScarlet = ThreadPoolManager.getInstance().scheduleGeneral(new weakscarlet(), 1000L);
                    FrintezzaManagerFinalBattle.this._skillFrintezza = ThreadPoolManager.getInstance().scheduleGeneral(new frinteza(), 1000L);
                }
            }
        }
    }
}

