/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class BoatManager {
    private static final Logger _log = Logger.getLogger(BoatManager.class.getName());
    private Map<Integer, L2BoatInstance> _staticItems = new FastMap();
    private boolean _initialized;

    public static final BoatManager getInstance() {
        return SingletonHolder._instance;
    }

    private BoatManager() {
        _log.info("Initializing BoatManager");
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        this._initialized = true;
        if (!Config.ALLOW_BOAT) {
            this._initialized = false;
            return;
        }
        BufferedReader lnr = null;
        try {
            File doorData = new File(Config.DATAPACK_ROOT, "data/boat.csv");
            lnr = Util.utf8BufferedReader(doorData);
            String line = null;
            while ((line = lnr.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                L2BoatInstance boat = this.parseLine(line);
                boat.spawn();
                this._staticItems.put(boat.getObjectId(), boat);
                if (!Config.DEBUG) continue;
                _log.info("Boat ID : " + boat.getObjectId());
            }
        }
        catch (FileNotFoundException e) {
            this._initialized = false;
            _log.warning("boat.csv is missing in data folder");
        }
        catch (Exception e) {
            this._initialized = false;
            _log.warning("error while creating boat table " + e);
            e.printStackTrace();
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e1) {}
        }
    }

    private L2BoatInstance parseLine(String line) {
        StringTokenizer st = new StringTokenizer(line, ";");
        String name = st.nextToken();
        int id = Integer.parseInt(st.nextToken());
        int xspawn = Integer.parseInt(st.nextToken());
        int yspawn = Integer.parseInt(st.nextToken());
        int zspawn = Integer.parseInt(st.nextToken());
        int heading = Integer.parseInt(st.nextToken());
        StatsSet npcDat = new StatsSet();
        npcDat.set("npcId", id);
        npcDat.set("level", 0);
        npcDat.set("jClass", "boat");
        npcDat.set("baseSTR", 0);
        npcDat.set("baseCON", 0);
        npcDat.set("baseDEX", 0);
        npcDat.set("baseINT", 0);
        npcDat.set("baseWIT", 0);
        npcDat.set("baseMEN", 0);
        npcDat.set("baseShldDef", 0);
        npcDat.set("baseShldRate", 0);
        npcDat.set("baseAccCombat", 38);
        npcDat.set("baseEvasRate", 38);
        npcDat.set("baseCritRate", 38);
        npcDat.set("collision_radius", 0);
        npcDat.set("collision_height", 0);
        npcDat.set("sex", "male");
        npcDat.set("type", "");
        npcDat.set("baseAtkRange", 0);
        npcDat.set("baseMpMax", 0);
        npcDat.set("baseCpMax", 0);
        npcDat.set("rewardExp", 0);
        npcDat.set("rewardSp", 0);
        npcDat.set("basePAtk", 0);
        npcDat.set("baseMAtk", 0);
        npcDat.set("basePAtkSpd", 0);
        npcDat.set("aggroRange", 0);
        npcDat.set("baseMAtkSpd", 0);
        npcDat.set("rhand", 0);
        npcDat.set("lhand", 0);
        npcDat.set("armor", 0);
        npcDat.set("baseWalkSpd", 0);
        npcDat.set("baseRunSpd", 0);
        npcDat.set("name", name);
        npcDat.set("baseHpMax", 50000);
        npcDat.set("baseHpReg", 0.003f);
        npcDat.set("baseMpReg", 0.003f);
        npcDat.set("basePDef", 100);
        npcDat.set("baseMDef", 100);
        L2CharTemplate template = new L2CharTemplate(npcDat);
        L2BoatInstance boat = new L2BoatInstance(IdFactory.getInstance().getNextId(), template, name);
        boat.getPosition().setHeading(heading);
        boat.setXYZ(xspawn, yspawn, zspawn);
        boat.setId(id);
        int IdWaypoint1 = Integer.parseInt(st.nextToken());
        int IdWTicket1 = Integer.parseInt(st.nextToken());
        int ntx1 = Integer.parseInt(st.nextToken());
        int nty1 = Integer.parseInt(st.nextToken());
        int ntz1 = Integer.parseInt(st.nextToken());
        String npc1 = st.nextToken();
        String mess10_1 = st.nextToken();
        String mess5_1 = st.nextToken();
        String mess1_1 = st.nextToken();
        String mess0_1 = st.nextToken();
        String messb_1 = st.nextToken();
        boat.setTrajet1(IdWaypoint1, IdWTicket1, ntx1, nty1, ntz1, npc1, mess10_1, mess5_1, mess1_1, mess0_1, messb_1);
        IdWaypoint1 = Integer.parseInt(st.nextToken());
        IdWTicket1 = Integer.parseInt(st.nextToken());
        ntx1 = Integer.parseInt(st.nextToken());
        nty1 = Integer.parseInt(st.nextToken());
        ntz1 = Integer.parseInt(st.nextToken());
        npc1 = st.nextToken();
        mess10_1 = st.nextToken();
        mess5_1 = st.nextToken();
        mess1_1 = st.nextToken();
        mess0_1 = st.nextToken();
        messb_1 = st.nextToken();
        boat.setTrajet2(IdWaypoint1, IdWTicket1, ntx1, nty1, ntz1, npc1, mess10_1, mess5_1, mess1_1, mess0_1, messb_1);
        return boat;
    }

    public L2BoatInstance getBoat(int boatId) {
        if (this._staticItems == null) {
            this._staticItems = new FastMap();
        }
        return this._staticItems.get(boatId);
    }

    private static class SingletonHolder {
        protected static final BoatManager _instance = new BoatManager();

        private SingletonHolder() {
        }
    }
}

