/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.idfactory;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.idfactory.IdFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

public class CompactionIDFactory
extends IdFactory {
    private static Logger _log = Logger.getLogger(CompactionIDFactory.class.getName());
    private int _curOID = 0x10000000;
    private int _freeSize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompactionIDFactory() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            int[] tmp_obj_ids = this.extractUsedObjectIDTable();
            int N = tmp_obj_ids.length;
            for (int idx = 0; idx < N; ++idx) {
                N = this.insertUntil(tmp_obj_ids, idx, N, con);
            }
            ++this._curOID;
            _log.config("IdFactory: Next usable Object ID is: " + this._curOID);
            this._initialized = true;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            _log.severe("ID Factory could not be initialized correctly:" + e1);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private int insertUntil(int[] tmp_obj_ids, int idx, int N, Connection con) throws SQLException {
        int hole;
        int id = tmp_obj_ids[idx];
        if (id == this._curOID) {
            ++this._curOID;
            return N;
        }
        if (Config.BAD_ID_CHECKING) {
            for (String check : ID_CHECKS) {
                PreparedStatement ps = con.prepareStatement(check);
                ps.setInt(1, this._curOID);
                ps.setInt(2, id);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    int badId = rs.getInt(1);
                    _log.severe("Bad ID " + badId + " in DB found by: " + check);
                    throw new RuntimeException();
                }
                rs.close();
                ps.close();
            }
        }
        if ((hole = id - this._curOID) > N - idx) {
            hole = N - idx;
        }
        for (int i = 1; i <= hole; ++i) {
            id = tmp_obj_ids[N - i];
            _log.info("Compacting DB object ID=" + id + " into " + this._curOID);
            for (String update : ID_UPDATES) {
                PreparedStatement ps = con.prepareStatement(update);
                ps.setInt(1, this._curOID);
                ps.setInt(2, id);
                ps.execute();
                ps.close();
            }
            ++this._curOID;
        }
        if (hole < N - idx) {
            ++this._curOID;
        }
        return N - hole;
    }

    @Override
    public synchronized int getNextId() {
        return this._curOID++;
    }

    @Override
    public synchronized void releaseId(int id) {
    }

    @Override
    public int size() {
        return this._freeSize + Integer.MAX_VALUE - 0x10000000;
    }
}

