/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IVoicedCommandHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import gnu.trove.TIntObjectHashMap;
import java.util.logging.Logger;

public class VoicedCommandHandler {
    private static Logger _log = Logger.getLogger(ItemHandler.class.getName());
    private TIntObjectHashMap<IVoicedCommandHandler> _datatable = new TIntObjectHashMap();

    public static VoicedCommandHandler getInstance() {
        return SingletonHolder._instance;
    }

    private VoicedCommandHandler() {
    }

    public void registerVoicedCommandHandler(IVoicedCommandHandler handler) {
        String[] ids = handler.getVoicedCommandList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for command " + ids[i]);
            }
            this._datatable.put(ids[i].hashCode(), (Object)handler);
        }
    }

    public IVoicedCommandHandler getVoicedCommandHandler(String voicedCommand) {
        String command = voicedCommand;
        if (voicedCommand.indexOf(" ") != -1) {
            command = voicedCommand.substring(0, voicedCommand.indexOf(" "));
        }
        if (Config.DEBUG) {
            _log.fine("getting handler for command: " + command + " -> " + (this._datatable.get(command.hashCode()) != null));
        }
        return (IVoicedCommandHandler)this._datatable.get(command.hashCode());
    }

    public int size() {
        return this._datatable.size();
    }

    private static class SingletonHolder {
        protected static final VoicedCommandHandler _instance = new VoicedCommandHandler();

        private SingletonHolder() {
        }
    }
}

