/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class SpawnTable {
    private static Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private Map<Integer, L2Spawn> _spawntable = new FastMap().shared();
    private int _npcSpawnCount;
    private int _customSpawnCount;
    private int _highestId;

    public static SpawnTable getInstance() {
        return SingletonHolder._instance;
    }

    private SpawnTable() {
        if (!Config.ALT_DEV_NO_SPAWNS) {
            this.fillSpawnTable();
        }
    }

    public Map<Integer, L2Spawn> getSpawnTable() {
        return this._spawntable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSpawnTable() {
        int loc_id;
        L2Spawn spawnDat;
        L2NpcTemplate template1;
        ResultSet rset;
        PreparedStatement statement;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = Config.DELETE_GMSPAWN_ON_CUSTOM ? con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, loc_id, periodOfDay FROM spawnlist where id NOT in ( select id from custom_notspawned where isCustom = false ) ORDER BY id") : con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, loc_id, periodOfDay FROM spawnlist ORDER BY id");
            rset = statement.executeQuery();
            while (rset.next()) {
                template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    if (template1.type.equalsIgnoreCase("L2SiegeGuard") || template1.type.equalsIgnoreCase("L2RaidBoss") || !Config.ALLOW_CLASS_MASTERS && template1.type.equals("L2ClassMaster")) continue;
                    spawnDat = new L2Spawn(template1);
                    spawnDat.setId(rset.getInt("id"));
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    loc_id = rset.getInt("loc_id");
                    spawnDat.setLocation(loc_id);
                    switch (rset.getInt("periodOfDay")) {
                        case 0: {
                            this._npcSpawnCount += spawnDat.init();
                            break;
                        }
                        case 1: {
                            DayNightSpawnManager.getInstance().addDayCreature(spawnDat);
                            ++this._npcSpawnCount;
                            break;
                        }
                        case 2: {
                            DayNightSpawnManager.getInstance().addNightCreature(spawnDat);
                            ++this._npcSpawnCount;
                        }
                    }
                    this._spawntable.put(spawnDat.getId(), spawnDat);
                    if (spawnDat.getId() <= this._highestId) continue;
                    this._highestId = spawnDat.getId();
                    continue;
                }
                _log.warning("SpawnTable: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("SpawnTable: Spawn could not be initialized: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        _log.config("SpawnTable: Loaded " + this._spawntable.size() + " Npc Spawn Locations.");
        if (Config.CUSTOM_SPAWNLIST_TABLE) {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = Config.DELETE_GMSPAWN_ON_CUSTOM ? con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, loc_id, periodOfDay FROM custom_spawnlist where id NOT in ( select id from custom_notspawned where isCustom = true ) ORDER BY id") : con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, loc_id, periodOfDay FROM custom_spawnlist ORDER BY id");
                rset = statement.executeQuery();
                while (rset.next()) {
                    template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                    if (template1 != null) {
                        if (template1.type.equalsIgnoreCase("L2SiegeGuard") || template1.type.equalsIgnoreCase("L2RaidBoss") || !Config.ALLOW_CLASS_MASTERS && template1.type.equals("L2ClassMaster")) continue;
                        spawnDat = new L2Spawn(template1);
                        spawnDat.setId(rset.getInt("id"));
                        spawnDat.setAmount(rset.getInt("count"));
                        spawnDat.setLocx(rset.getInt("locx"));
                        spawnDat.setLocy(rset.getInt("locy"));
                        spawnDat.setLocz(rset.getInt("locz"));
                        spawnDat.setHeading(rset.getInt("heading"));
                        spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                        spawnDat.setCustom(true);
                        loc_id = rset.getInt("loc_id");
                        spawnDat.setLocation(loc_id);
                        switch (rset.getInt("periodOfDay")) {
                            case 0: {
                                this._customSpawnCount += spawnDat.init();
                                break;
                            }
                            case 1: {
                                DayNightSpawnManager.getInstance().addDayCreature(spawnDat);
                                ++this._customSpawnCount;
                                break;
                            }
                            case 2: {
                                DayNightSpawnManager.getInstance().addNightCreature(spawnDat);
                                ++this._customSpawnCount;
                            }
                        }
                        this._spawntable.put(spawnDat.getId(), spawnDat);
                        if (spawnDat.getId() <= this._highestId) continue;
                        this._highestId = spawnDat.getId();
                        continue;
                    }
                    _log.warning("CustomSpawnTable: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
                }
                rset.close();
                statement.close();
            }
            catch (Exception e) {
                _log.warning("CustomSpawnTable: Spawn could not be initialized: " + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            _log.config("CustomSpawnTable: Loaded " + this._customSpawnCount + " Npc Spawn Locations.");
        }
        if (Config.DEBUG) {
            _log.fine("SpawnTable: Spawning completed, total number of NPCs in the world: " + (this._npcSpawnCount + this._customSpawnCount));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSpawn(L2Spawn spawn, boolean storeInDb) {
        Map<Integer, L2Spawn> map = this._spawntable;
        synchronized (map) {
            ++this._highestId;
            spawn.setId(this._highestId);
            this._spawntable.put(this._highestId, spawn);
        }
        if (storeInDb) {
            Connection con = null;
            String spawnTable = spawn.isCustom() && Config.CUSTOM_SPAWNLIST_TABLE ? "custom_spawnlist" : "spawnlist";
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("INSERT INTO " + spawnTable + "(id,count,npc_templateid,locx,locy,locz,heading,respawn_delay,loc_id) values(?,?,?,?,?,?,?,?,?)");
                statement.setInt(1, spawn.getId());
                statement.setInt(2, spawn.getAmount());
                statement.setInt(3, spawn.getNpcid());
                statement.setInt(4, spawn.getLocx());
                statement.setInt(5, spawn.getLocy());
                statement.setInt(6, spawn.getLocz());
                statement.setInt(7, spawn.getHeading());
                statement.setInt(8, spawn.getRespawnDelay() / 1000);
                statement.setInt(9, spawn.getLocation());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.warning("SpawnTable: Could not store spawn in the DB:" + e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
            String zoneName = MapRegionTable.getInstance().getClosestTownName(spawn.getLocx(), spawn.getLocy());
            SpawnTable.addSqlLog("-- " + spawn.getTemplate().title + " " + spawn.getTemplate().name + " - " + zoneName + "\r\n" + "INSERT INTO " + spawnTable + " SET location='//spawn." + zoneName + "'" + ", count=" + spawn.getAmount() + ", npc_templateid=" + spawn.getNpcid() + ", locx=" + spawn.getLocx() + ", locy=" + spawn.getLocy() + ", locz=" + spawn.getLocz() + ", heading=" + spawn.getHeading() + ", respawn_delay=" + spawn.getRespawnDelay() / 1000 + ", loc_id=" + spawn.getLocation() + ";\r\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpawn(L2Spawn spawn, boolean updateDb) {
        if (this._spawntable.remove(spawn.getId()) == null) {
            return;
        }
        if (updateDb) {
            PreparedStatement statement;
            Connection con = null;
            if (Config.DELETE_GMSPAWN_ON_CUSTOM) {
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    statement = con.prepareStatement("Replace into custom_notspawned VALUES (?,?)");
                    statement.setInt(1, spawn.getId());
                    statement.setBoolean(2, spawn.isCustom());
                    statement.execute();
                    statement.close();
                }
                catch (Exception e) {
                    _log.warning("SpawnTable: Spawn " + spawn.getId() + " could not be insert into DB: " + e);
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
            } else {
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    statement = con.prepareStatement("DELETE FROM " + (spawn.isCustom() ? "custom_spawnlist" : "spawnlist") + " WHERE id=?");
                    statement.setInt(1, spawn.getId());
                    statement.execute();
                    statement.close();
                }
                catch (Exception e) {
                    _log.warning("SpawnTable: Spawn " + spawn.getId() + " could not be removed from DB: " + e);
                }
                finally {
                    try {
                        con.close();
                    }
                    catch (Exception e) {}
                }
            }
            String zoneName = MapRegionTable.getInstance().getClosestTownName(spawn.getLocx(), spawn.getLocy());
            String spawnTable = spawn.isCustom() ? "custom_spawnlist" : "spawnlist";
            SpawnTable.addSqlLog("-- " + spawn.getTemplate().title + " " + spawn.getTemplate().name + " - " + zoneName + "\r\n" + "DELETE FROM " + spawnTable + " WHERE " + " count=" + spawn.getAmount() + " AND npc_templateid=" + spawn.getNpcid() + " AND locx=" + spawn.getLocx() + " AND locy=" + spawn.getLocy() + " AND locz=" + spawn.getLocz() + " AND heading=" + spawn.getHeading() + " AND respawn_delay=" + spawn.getRespawnDelay() / 1000 + " AND loc_id=" + spawn.getLocation() + ";\r\n");
        }
    }

    public void reloadAll() {
        this.fillSpawnTable();
    }

    public void findNPCInstances(L2PcInstance activeChar, int npcId, int teleportIndex) {
        int index = 0;
        for (L2Spawn spawn : this._spawntable.values()) {
            if (npcId != spawn.getNpcid()) continue;
            ++index;
            if (teleportIndex > -1) {
                if (teleportIndex != index) continue;
                this.meet(activeChar, spawn);
                continue;
            }
            if (index == 1) {
                activeChar.sendMessage(spawn.getNpcid() + " " + spawn.getTemplate().name);
            }
            activeChar.sendMessage("- " + index + ". (" + spawn.getId() + "): " + spawn.getLocx() + " " + spawn.getLocy() + " " + spawn.getLocz());
        }
        if (index == 0) {
            activeChar.sendMessage("No current spawns found.");
        }
    }

    private void meet(L2PcInstance activeChar, L2Spawn spawn) {
        int z;
        int y;
        int x;
        L2Npc npc = spawn.getLastSpawn();
        if (npc != null && npc.isVisible()) {
            double a = (double)npc.getHeading() * 9.587379924285257E-5;
            double r = Math.max(npc.getCollisionRadius(), npc.getCollisionHeight()) + activeChar.getCollisionRadius() + 60.0;
            x = npc.getX() + (int)Math.ceil(r * Math.cos(a));
            y = npc.getY() + (int)Math.ceil(r * Math.sin(a));
            z = npc.getZ();
        } else {
            x = spawn.getLocx();
            y = spawn.getLocy();
            z = spawn.getLocz();
        }
        activeChar.teleToLocation(x, y, z, false);
    }

    public void addNewSpawnOne(L2Npc npc) {
        int npcId = npc.getNpcId();
        for (L2Spawn spawn : this._spawntable.values()) {
            if (spawn.getNpcid() != npcId) continue;
            this._spawntable.remove(spawn.getId());
        }
        this.addNewSpawn(npc.getSpawn(), false);
    }

    public void deleteSpawnOne(L2Npc npc) {
        this._spawntable.remove(npc.getSpawn().getId());
    }

    public L2Spawn getSpawnOne(int npcId) {
        for (L2Spawn spawn : this._spawntable.values()) {
            if (spawn.getNpcid() != npcId) continue;
            return spawn;
        }
        return null;
    }

    private static void addSqlLog(String sql) {
        System.out.print(sql);
        try {
            FileWriter save = new FileWriter("log/_spawnlist.sql", true);
            save.write(sql);
            save.flush();
            save.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class SingletonHolder {
        protected static final SpawnTable _instance = new SpawnTable();

        private SingletonHolder() {
        }
    }
}

