/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;
import javolution.util.FastList;

public class NpcWalkerRoutesTable {
    private static final Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private FastList<L2NpcWalkerNode> _routes = new FastList();

    public static NpcWalkerRoutesTable getInstance() {
        return SingletonHolder._instance;
    }

    private NpcWalkerRoutesTable() {
        _log.info("Initializing Walkers Routes Table.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        this._routes.clear();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT route_id, npc_id, move_point, chatText, move_x, move_y, move_z, delay, running FROM walker_routes ORDER By move_point ASC");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcWalkerNode route = new L2NpcWalkerNode();
                route.setRouteId(rset.getInt("route_id"));
                route.setNpcId(rset.getInt("npc_id"));
                route.setMovePoint(rset.getInt("move_point"));
                route.setChatText(rset.getString("chatText"));
                route.setMoveX(rset.getInt("move_x"));
                route.setMoveY(rset.getInt("move_y"));
                route.setMoveZ(rset.getInt("move_z"));
                route.setDelay(rset.getInt("delay"));
                route.setRunning(rset.getBoolean("running"));
                this._routes.add((Object)route);
            }
            rset.close();
            statement.close();
            _log.info("WalkerRoutesTable: Loaded " + this._routes.size() + " Npc Walker Routes.");
        }
        catch (Exception e) {
            _log.severe("WalkerRoutesTable: Error while loading Npc Walkers Routes: " + e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public FastList<L2NpcWalkerNode> getRouteForNpc(int id) {
        FastList _return = new FastList();
        FastList.Node n = this._routes.head();
        FastList.Node end = this._routes.tail();
        while ((n = n.getNext()) != end) {
            if (((L2NpcWalkerNode)n.getValue()).getNpcId() != id) continue;
            _return.add(n.getValue());
        }
        return _return;
    }

    private static class SingletonHolder {
        protected static final NpcWalkerRoutesTable _instance = new NpcWalkerRoutesTable();

        private SingletonHolder() {
        }
    }
}

