/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.skills.funcs.LambdaConst;
import com.l2jserver.gameserver.templates.item.L2Item;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EnchantHPBonusData {
    protected static final Logger _log = Logger.getLogger(EnchantHPBonusData.class.getName());
    private final TIntObjectHashMap<Integer[]> _singleArmorHPBonus = new TIntObjectHashMap();
    private final TIntObjectHashMap<Integer[]> _fullArmorHPBonus = new TIntObjectHashMap();

    public static final EnchantHPBonusData getInstance() {
        return SingletonHolder._instance;
    }

    private EnchantHPBonusData() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/enchantHPBonus.xml");
        Document doc = null;
        if (file.exists()) {
            L2Item item;
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"enchantHP".equalsIgnoreCase(d.getNodeName())) continue;
                    NamedNodeMap attrs = d.getAttributes();
                    Node att = attrs.getNamedItem("grade");
                    if (att == null) {
                        _log.severe("[EnchantHPBonusData] Missing grade, skipping");
                        continue;
                    }
                    Integer grade = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("fullArmor");
                    if (att == null) {
                        _log.severe("[EnchantHPBonusData] Missing fullArmor, skipping");
                        continue;
                    }
                    boolean fullArmor = Boolean.valueOf(att.getNodeValue());
                    att = attrs.getNamedItem("values");
                    if (att == null) {
                        _log.severe("[EnchantHPBonusData] Missing bonus id: " + grade + ", skipping");
                        continue;
                    }
                    StringTokenizer st = new StringTokenizer(att.getNodeValue(), ",");
                    int tokenCount = st.countTokens();
                    Integer[] bonus = new Integer[tokenCount];
                    for (int i = 0; i < tokenCount; ++i) {
                        Integer value = Integer.decode(st.nextToken().trim());
                        if (value == null) {
                            _log.severe("[EnchantHPBonusData] Bad Hp value!! grade: " + grade + " FullArmor? " + fullArmor + " token: " + i);
                            value = 0;
                        }
                        bonus[i] = value;
                    }
                    if (fullArmor) {
                        this._fullArmorHPBonus.put(grade.intValue(), (Object)bonus);
                        continue;
                    }
                    this._singleArmorHPBonus.put(grade.intValue(), (Object)bonus);
                }
            }
            if (this._fullArmorHPBonus.isEmpty() && this._singleArmorHPBonus.isEmpty()) {
                return;
            }
            Collection<Integer> itemIds = ItemTable.getInstance().getAllArmorsId();
            int count = 0;
            for (Integer itemId : itemIds) {
                item = ItemTable.getInstance().getTemplate(itemId);
                if (item == null || item.getCrystalType() == 0) continue;
                switch (item.getBodyPart()) {
                    case 1: 
                    case 64: 
                    case 256: 
                    case 512: 
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 32768: {
                        ++count;
                        FuncTemplate ft = new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0));
                        item.attach(ft);
                    }
                }
            }
            itemIds = ItemTable.getInstance().getAllWeaponsId();
            for (Integer itemId : itemIds) {
                item = ItemTable.getInstance().getTemplate(itemId);
                if (item == null || item.getCrystalType() == 0) continue;
                switch (item.getBodyPart()) {
                    case 256: {
                        ++count;
                        FuncTemplate ft = new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0));
                        item.attach(ft);
                    }
                }
            }
            _log.info("Enchant HP Bonus registered for " + count + " items!");
        }
    }

    public final int getHPBonus(L2ItemInstance item) {
        Integer[] values = item.getItem().getBodyPart() == 32768 ? (Integer[])this._fullArmorHPBonus.get(item.getItem().getItemGradeSPlus()) : (Integer[])this._singleArmorHPBonus.get(item.getItem().getItemGradeSPlus());
        if (values == null || values.length == 0) {
            return 0;
        }
        return values[Math.min(item.getEnchantLevel(), values.length) - 1];
    }

    private static class SingletonHolder {
        protected static final EnchantHPBonusData _instance = new EnchantHPBonusData();

        private SingletonHolder() {
        }
    }
}

