/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai2;

import com.l2jserver.gameserver.datatables.NpcTable;
import java.util.Set;
import javolution.util.FastSet;

public class AiPlugingParameters {
    private Set<String> _npcClassTypes;
    private Set<Class<?>> _npcL2jClasses;
    private Set<String> _aiTypes;
    private Set<Integer> _npcIDs;
    private boolean _converted;
    private AiPlugingParameters _but;

    public AiPlugingParameters(Set<String> npcClassTypes, Set<Class<?>> npcL2jClasses, Set<String> aiTypes, Set<Integer> npcIDs, AiPlugingParameters but) {
        this._npcClassTypes = npcClassTypes;
        this._npcL2jClasses = npcL2jClasses;
        this._aiTypes = aiTypes;
        this._npcIDs = npcIDs;
        this._but = but;
        if (this._npcIDs == null) {
            this._npcIDs = new FastSet();
        }
    }

    public void convertToIDs() {
        if (this._but != null && !this._but.isEmpty()) {
            this._but.convertToIDs();
        }
        if (this._npcClassTypes != null) {
            for (String string : this._npcClassTypes) {
                this._npcIDs.addAll(NpcTable.getInstance().getAllNpcOfClassType(string));
            }
        }
        if (this._npcL2jClasses != null) {
            for (Class clazz : this._npcL2jClasses) {
                this._npcIDs.addAll(NpcTable.getInstance().getAllNpcOfL2jClass(clazz));
            }
        }
        if (this._aiTypes != null) {
            for (String string : this._aiTypes) {
                this._npcIDs.addAll(NpcTable.getInstance().getAllNpcOfAiType(string));
            }
        }
        if (this._but != null && !this._but.isEmpty()) {
            this.removeIDs(this._but.getIDs());
        }
        this._converted = true;
    }

    public boolean isEmpty() {
        return this._npcIDs.isEmpty() && this._aiTypes.isEmpty() && this._npcL2jClasses.isEmpty() && this._npcClassTypes.isEmpty();
    }

    public boolean isConverted() {
        return this._converted;
    }

    public void removeIDs(Set<Integer> ids) {
        this._npcIDs.removeAll(ids);
    }

    public Set<Integer> getIDs() {
        return this._npcIDs;
    }

    public boolean contains(int id) {
        if (!this._converted) {
            throw new IllegalStateException("Can not call 'contain' method on a non-converted AiPluginParameters");
        }
        if (this._but == null) {
            return this._npcIDs.contains(id);
        }
        return this._npcIDs.contains(id) && !this._but.contains(id);
    }

    public boolean equals(AiPlugingParameters pparams) {
        if (!this._converted) {
            throw new IllegalStateException("Can not call 'equals' method on a non-converted AiPluginParameters");
        }
        return this._npcIDs.containsAll(pparams.getIDs()) && pparams.getIDs().containsAll(this._npcIDs);
    }
}

