/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai2;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai2.AiInstance;
import com.l2jserver.gameserver.ai2.AiPlugingParameters;
import com.l2jserver.gameserver.ai2.EventHandler;
import com.l2jserver.gameserver.ai2.ISpecificAiManager;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;

public class AiManager {
    protected static final Logger _log = Logger.getLogger(AiManager.class.getName());
    private List<AiInstance> _aiList = new FastList();
    private TIntObjectHashMap<AiInstance> _aiMap = new TIntObjectHashMap();
    private ThreadPoolManager _tpm = ThreadPoolManager.getInstance();
    private Map<String, String> _paramcache = new FastMap();

    public static AiManager getInstance() {
        return SingletonHolder._instance;
    }

    private AiManager() {
        this.load();
    }

    public void load() {
        try {
            JarFile jar = new JarFile("./l2jserver.jar");
            URL url = Class.class.getResource("/net/sf/l2j/gameserver/ai/managers");
            if (url == null) {
                _log.severe("Could not open the ai managers folder. No ai will be loaded!");
                return;
            }
            File directory = new File(url.getFile());
            for (String file : directory.list()) {
                if (!file.endsWith(".class")) continue;
                try {
                    Class<?> managerClass = Class.forName("com.l2jserver.gameserver.ai.managers." + file.substring(0, file.length() - 6));
                    Object managerObject = managerClass.newInstance();
                    if (!(managerObject instanceof ISpecificAiManager)) {
                        _log.info("A class that was not a ISpecificAiManager was found in the ai managers folder.");
                        continue;
                    }
                    ISpecificAiManager managerInstance = (ISpecificAiManager)managerObject;
                    for (EventHandler handler : managerInstance.getEventHandlers()) {
                        AiPlugingParameters pparams = handler.getPlugingParameters();
                        pparams.convertToIDs();
                        boolean perfectMatch = false;
                        FastList intersections = new FastList();
                        for (AiInstance ai : this._aiList) {
                            if (ai.getPluginingParamaters().equals(pparams)) {
                                ai.addHandler(handler);
                                perfectMatch = true;
                                break;
                            }
                            Intersection intersection = new Intersection(ai);
                            for (int id : pparams.getIDs()) {
                                if (!ai.getPluginingParamaters().contains(id)) continue;
                                intersection.ids.add(id);
                            }
                            if (intersection.isEmpty()) continue;
                            intersections.add(intersection);
                        }
                        if (perfectMatch) continue;
                        for (Intersection i : intersections) {
                            pparams.removeIDs(i.ids);
                            i.ai.getPluginingParamaters().removeIDs(i.ids);
                            AiPlugingParameters newAiPparams = new AiPlugingParameters(null, null, null, i.ids, null);
                            AiInstance newAi = new AiInstance(i.ai, newAiPparams);
                            newAi.addHandler(handler);
                            this._aiList.add(newAi);
                        }
                        if (pparams.isEmpty()) continue;
                        AiInstance newAi = new AiInstance(pparams);
                        newAi.addHandler(handler);
                        this._aiList.add(newAi);
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (AiInstance ai : this._aiList) {
            for (Integer i : ai.getHandledNPCIds()) {
                this._aiMap.put(i.intValue(), (Object)ai);
            }
        }
    }

    public void executeEventHandler(AiInstance.QueueEventRunner runner) {
        this._tpm.executeAi(runner);
    }

    public void addAiInstance(AiInstance instance) {
        this._aiList.add(instance);
    }

    public AiInstance getAiForNPCId(int npcId) {
        return (AiInstance)this._aiMap.get(npcId);
    }

    public String getParameter(String who, String paramsType, String param1, String param2) {
        String key = who + ":" + paramsType + ":" + param1 + ":" + param2;
        String cacheResult = this._paramcache.get(key);
        if (cacheResult != null) {
            return cacheResult;
        }
        Object result = null;
        this._paramcache.put(key, (String)result);
        return null;
    }

    private static class SingletonHolder {
        protected static final AiManager _instance = new AiManager();

        private SingletonHolder() {
        }
    }

    private class Intersection {
        public AiInstance ai;
        public Set<Integer> ids;

        public Intersection(AiInstance instance) {
            this.ai = instance;
            this.ids = new FastSet();
        }

        public boolean isEmpty() {
            return this.ids.isEmpty();
        }
    }
}

