/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2PlayableAI;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;

public class L2SummonAI
extends L2PlayableAI {
    private boolean _thinking;
    private boolean _startFollow;

    public L2SummonAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this._startFollow = ((L2Summon)this._actor).getFollowStatus();
    }

    @Override
    protected void onIntentionIdle() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        this.stopFollow();
        this._startFollow = false;
        this.onIntentionActive();
    }

    @Override
    protected void onIntentionActive() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        L2Summon summon = (L2Summon)this._actor;
        if (this._startFollow) {
            this.setIntention(CtrlIntention.AI_INTENTION_FOLLOW, summon.getOwner());
        } else {
            super.onIntentionActive();
        }
    }

    private void thinkAttack() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        if (this.checkTargetLostOrDead(this.getAttackTarget())) {
            this.setAttackTarget(null);
            return;
        }
        if (this.maybeMoveToPawn(this.getAttackTarget(), this._actor.getPhysicalAttackRange())) {
            return;
        }
        this.clientStopMoving(null);
        this._accessor.doAttack(this.getAttackTarget());
    }

    private void thinkCast() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        L2Summon summon = (L2Summon)this._actor;
        if (this.checkTargetLost(this.getCastTarget())) {
            this.setCastTarget(null);
            return;
        }
        boolean val = this._startFollow;
        if (this.maybeMoveToPawn(this.getCastTarget(), this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        this.clientStopMoving(null);
        summon.setFollowStatus(false);
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this._startFollow = val;
        this._accessor.doCast(this._skill);
    }

    private void thinkPickUp() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        if (this.checkTargetLost(this.getTarget())) {
            return;
        }
        if (this.maybeMoveToPawn(this.getTarget(), 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
        ((L2Summon.AIAccessor)this._accessor).doPickupItem(this.getTarget());
    }

    private void thinkInteract() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        if (this.checkTargetLost(this.getTarget())) {
            return;
        }
        if (this.maybeMoveToPawn(this.getTarget(), 36)) {
            return;
        }
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onEvtThink() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        if (this._thinking) return;
        if (this._actor.isCastingNow()) return;
        if (this._actor.isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            switch (this.getIntention()) {
                case AI_INTENTION_ATTACK: {
                    this.thinkAttack();
                    return;
                }
                case AI_INTENTION_CAST: {
                    this.thinkCast();
                    return;
                }
                case AI_INTENTION_PICK_UP: {
                    this.thinkPickUp();
                    return;
                }
                case AI_INTENTION_INTERACT: {
                    this.thinkInteract();
                    return;
                }
            }
            return;
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtFinishCasting() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        if (this._actor.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            ((L2Summon)this._actor).setFollowStatus(this._startFollow);
        }
    }

    public void notifyFollowStatusChange() {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        this._startFollow = !this._startFollow;
        switch (this.getIntention()) {
            case AI_INTENTION_PICK_UP: 
            case AI_INTENTION_ACTIVE: 
            case AI_INTENTION_FOLLOW: 
            case AI_INTENTION_IDLE: 
            case AI_INTENTION_MOVE_TO: {
                ((L2Summon)this._actor).setFollowStatus(this._startFollow);
            }
        }
    }

    public void setStartFollowController(boolean val) {
        if (this._actor instanceof L2MerchantSummonInstance) {
            return;
        }
        this._startFollow = val;
    }
}

