/*
 * Decompiled with CFR 0.152.
 */
package javolution.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javolution.io.UTF8ByteBufferReader;
import javolution.io.UTF8ByteBufferWriter;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.Reflection;
import javolution.text.TextBuilder;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Struct {
    public static final Configurable<Integer> MAXIMUM_ALIGNMENT = new Configurable(new Integer(4)){};
    private Struct _outer;
    private ByteBuffer _byteBuffer;
    private int _outerOffset;
    private int _alignment = 1;
    private int _size;
    private int _index;
    private int _wordSize;
    private int _bitsUsed;
    private boolean _resetIndex = this.isUnion();
    private byte[] _bytes;
    private static final Reflection.Method ADDRESS_METHOD = Reflection.getInstance().getMethod("sun.nio.ch.DirectBuffer.address()");
    private static final char[] HEXA = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Class BOOL = new Bool[0].getClass();
    private static final Class SIGNED_8 = new Signed8[0].getClass();
    private static final Class UNSIGNED_8 = new Unsigned8[0].getClass();
    private static final Class SIGNED_16 = new Signed16[0].getClass();
    private static final Class UNSIGNED_16 = new Unsigned16[0].getClass();
    private static final Class SIGNED_32 = new Signed32[0].getClass();
    private static final Class UNSIGNED_32 = new Unsigned32[0].getClass();
    private static final Class SIGNED_64 = new Signed64[0].getClass();
    private static final Class FLOAT_32 = new Float32[0].getClass();
    private static final Class FLOAT_64 = new Float64[0].getClass();

    public final int size() {
        return this._size;
    }

    public Struct outer() {
        return this._outer;
    }

    public final ByteBuffer getByteBuffer() {
        if (this._outer != null) {
            return this._outer.getByteBuffer();
        }
        return this._byteBuffer != null ? this._byteBuffer : this.newBuffer();
    }

    private synchronized ByteBuffer newBuffer() {
        if (this._byteBuffer != null) {
            return this._byteBuffer;
        }
        ByteBuffer bf = ByteBuffer.allocateDirect(this.size());
        bf.order(this.byteOrder());
        this.setByteBuffer(bf, 0);
        return this._byteBuffer;
    }

    public final Struct setByteBuffer(ByteBuffer byteBuffer, int position) {
        if (byteBuffer.order() != this.byteOrder()) {
            throw new IllegalArgumentException("The byte order of the specified byte buffer is different from this struct byte order");
        }
        if (this._outer != null) {
            throw new UnsupportedOperationException("Inner struct byte buffer is inherited from outer");
        }
        this._byteBuffer = byteBuffer;
        this._outerOffset = position;
        return this;
    }

    public final Struct setByteBufferPosition(int position) {
        return this.setByteBuffer(this.getByteBuffer(), position);
    }

    public final int getByteBufferPosition() {
        return this._outer != null ? this._outer.getByteBufferPosition() + this._outerOffset : this._outerOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(InputStream in) throws IOException {
        ByteBuffer buffer = this.getByteBuffer();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + this.getByteBufferPosition();
            return in.read(buffer.array(), offset, this.size());
        }
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            if (this._bytes == null) {
                this._bytes = new byte[this.size()];
            }
            int bytesRead = in.read(this._bytes);
            buffer.position(this.getByteBufferPosition());
            buffer.put(this._bytes);
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        ByteBuffer buffer = this.getByteBuffer();
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + this.getByteBufferPosition();
            out.write(buffer.array(), offset, this.size());
        } else {
            ByteBuffer byteBuffer = buffer;
            synchronized (byteBuffer) {
                if (this._bytes == null) {
                    this._bytes = new byte[this.size()];
                }
                buffer.position(this.getByteBufferPosition());
                buffer.get(this._bytes);
                out.write(this._bytes);
            }
        }
    }

    public final long address() {
        ByteBuffer thisBuffer = this.getByteBuffer();
        if (ADDRESS_METHOD != null) {
            Long start = (Long)ADDRESS_METHOD.invoke(thisBuffer);
            return start + (long)this.getByteBufferPosition();
        }
        throw new UnsupportedOperationException("Operation not supported for " + thisBuffer.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            int size = this.size();
            ByteBuffer buffer = this.getByteBuffer();
            int start = this.getByteBufferPosition();
            for (int i = 0; i < size; ++i) {
                int b = buffer.get(start + i) & 0xFF;
                tmp.append(HEXA[b >> 4]);
                tmp.append(HEXA[b & 0xF]);
                tmp.append((i & 0xF) == 15 ? (char)'\n' : ' ');
            }
            String string = tmp.toString();
            return string;
        }
        finally {
            TextBuilder.recycle(tmp);
        }
    }

    public boolean isUnion() {
        return false;
    }

    public ByteOrder byteOrder() {
        return this._outer != null ? this._outer.byteOrder() : ByteOrder.BIG_ENDIAN;
    }

    public boolean isPacked() {
        return false;
    }

    protected <S extends Struct> S inner(S struct) {
        if (struct._outer != null) {
            throw new IllegalArgumentException("struct: Already an inner struct");
        }
        Member inner = new Member(struct._size << 3, struct._alignment);
        struct._outer = this;
        struct._outerOffset = inner.offset();
        return struct;
    }

    protected <S extends Struct> S[] array(S[] structs) {
        Class structClass = null;
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        int i = 0;
        while (i < structs.length) {
            Object struct = structs[i];
            if (struct == null) {
                try {
                    if (structClass == null) {
                        String arrayName = structs.getClass().getName();
                        String structName = arrayName.substring(2, arrayName.length() - 1);
                        structClass = Reflection.getInstance().getClass(structName);
                        if (structClass == null) {
                            throw new IllegalArgumentException("Struct class: " + structName + " not found");
                        }
                    }
                    struct = (Struct)structClass.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            structs[i++] = this.inner(struct);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[])structs;
    }

    protected <S extends Struct> S[][] array(S[][] structs) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < structs.length; ++i) {
            this.array((Struct[])structs[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[][])structs;
    }

    protected <S extends Struct> S[][][] array(S[][][] structs) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < structs.length; ++i) {
            this.array((Struct[][])structs[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Struct[][][])structs;
    }

    protected <M extends Member> M[] array(M[] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        if (BOOL.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Bool();
            }
        } else if (SIGNED_8.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed8();
            }
        } else if (UNSIGNED_8.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned8();
            }
        } else if (SIGNED_16.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed16();
            }
        } else if (UNSIGNED_16.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned16();
            }
        } else if (SIGNED_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed32();
            }
        } else if (UNSIGNED_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Unsigned32();
            }
        } else if (SIGNED_64.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Signed64();
            }
        } else if (FLOAT_32.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Float32();
            }
        } else if (FLOAT_64.isInstance(arrayMember)) {
            int i = 0;
            while (i < arrayMember.length) {
                arrayMember[i++] = new Float64();
            }
        } else {
            throw new UnsupportedOperationException("Cannot create member elements, the arrayMember should contain the member instances instead of null");
        }
        this._resetIndex = resetIndexSaved;
        return (Member[])arrayMember;
    }

    protected <M extends Member> M[][] array(M[][] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < arrayMember.length; ++i) {
            this.array((Member[])arrayMember[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Member[][])arrayMember;
    }

    protected <M extends Member> M[][][] array(M[][][] arrayMember) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < arrayMember.length; ++i) {
            this.array((Member[][])arrayMember[i]);
        }
        this._resetIndex = resetIndexSaved;
        return (Member[][][])arrayMember;
    }

    protected UTF8String[] array(UTF8String[] array, int stringLength) {
        boolean resetIndexSaved = this._resetIndex;
        if (this._resetIndex) {
            this._index = 0;
            this._resetIndex = false;
        }
        for (int i = 0; i < array.length; ++i) {
            array[i] = new UTF8String(stringLength);
        }
        this._resetIndex = resetIndexSaved;
        return array;
    }

    public long readBits(int bitOffset, int bitSize) {
        if (bitOffset + bitSize - 1 >> 3 >= this.size()) {
            throw new IllegalArgumentException("Attempt to read outside the Struct");
        }
        int offset = bitOffset >> 3;
        int bitStart = bitOffset - (offset << 3);
        bitStart = this.byteOrder() == ByteOrder.BIG_ENDIAN ? bitStart : 64 - bitSize - bitStart;
        int index = this.getByteBufferPosition() + offset;
        long value = this.readByteBufferLong(index);
        value <<= bitStart;
        return value >>= 64 - bitSize;
    }

    private long readByteBufferLong(int index) {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (index + 8 < byteBuffer.limit()) {
            return byteBuffer.getLong(index);
        }
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            return (long)((Struct.readByte(index, byteBuffer) & 0xFF) + ((Struct.readByte(++index, byteBuffer) & 0xFF) << 8) + ((Struct.readByte(++index, byteBuffer) & 0xFF) << 16)) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 24) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 32) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 40) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 48) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 56);
        }
        return ((long)Struct.readByte(index, byteBuffer) << 56) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 48) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 40) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 32) + (((long)Struct.readByte(++index, byteBuffer) & 0xFFL) << 24) + (long)((Struct.readByte(++index, byteBuffer) & 0xFF) << 16) + (long)((Struct.readByte(++index, byteBuffer) & 0xFF) << 8) + ((long)Struct.readByte(++index, byteBuffer) & 0xFFL);
    }

    private static byte readByte(int index, ByteBuffer byteBuffer) {
        return index < byteBuffer.limit() ? byteBuffer.get(index) : (byte)0;
    }

    public void writeBits(long value, int bitOffset, int bitSize) {
        if (bitOffset + bitSize - 1 >> 3 >= this.size()) {
            throw new IllegalArgumentException("Attempt to write outside the Struct");
        }
        int offset = bitOffset >> 3;
        int bitStart = this.byteOrder() == ByteOrder.BIG_ENDIAN ? bitOffset - (offset << 3) : 64 - bitSize - (bitOffset - (offset << 3));
        long mask = -1L;
        mask <<= bitStart;
        mask >>>= 64 - bitSize;
        int index = this.getByteBufferPosition() + offset;
        long oldValue = this.readByteBufferLong(index);
        long resetValue = oldValue & ((mask <<= 64 - bitSize - bitStart) ^ 0xFFFFFFFFFFFFFFFFL);
        long newValue = resetValue | value << 64 - bitSize - bitStart;
        this.writeByteBufferLong(index, newValue);
    }

    private void writeByteBufferLong(int index, long value) {
        ByteBuffer byteBuffer = this.getByteBuffer();
        if (index + 8 < byteBuffer.limit()) {
            byteBuffer.putLong(index, value);
            return;
        }
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            Struct.writeByte(index, byteBuffer, (byte)value);
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 8));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 16));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 24));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 32));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 40));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 48));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 56));
        } else {
            Struct.writeByte(index, byteBuffer, (byte)(value >> 56));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 48));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 40));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 32));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 24));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 16));
            Struct.writeByte(++index, byteBuffer, (byte)(value >> 8));
            Struct.writeByte(++index, byteBuffer, (byte)value);
        }
    }

    private static void writeByte(int index, ByteBuffer byteBuffer, byte value) {
        if (index < byteBuffer.limit()) {
            byteBuffer.put(index, value);
        }
    }

    public class Enum64<T extends Enum>
    extends Member {
        private final Enum[] _values;

        public Enum64(Enum[] values) {
            super(64, 8);
            this._values = values;
        }

        public Enum64(Enum[] values, int nbrOfBits) {
            super(nbrOfBits, 8);
            this._values = values;
        }

        public Enum get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            long word = Struct.this.getByteBuffer().getLong(index);
            return this._values[(int)this.get(8, word)];
        }

        public void set(Enum e) {
            long value = e.ordinal();
            if (this._values[(int)value] != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            int index = Struct.this.getByteBufferPosition() + this.offset();
            long word = Struct.this.getByteBuffer().getLong(index);
            Struct.this.getByteBuffer().putLong(index, this.set(value, 8, word));
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Enum32<T extends Enum>
    extends Member {
        private final Enum[] _values;

        public Enum32(Enum[] values) {
            super(32, 4);
            this._values = values;
        }

        public Enum32(Enum[] values, int nbrOfBits) {
            super(nbrOfBits, 4);
            this._values = values;
        }

        public Enum get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().getInt(index);
            return this._values[this.get(4, word)];
        }

        public void set(Enum e) {
            int value = e.ordinal();
            if (this._values[value] != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().getInt(index);
            Struct.this.getByteBuffer().putInt(index, this.set(value, 4, word));
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Enum16<T extends Enum>
    extends Member {
        private final Enum[] _values;

        public Enum16(Enum[] values) {
            super(16, 2);
            this._values = values;
        }

        public Enum16(Enum[] values, int nbrOfBits) {
            super(nbrOfBits, 2);
            this._values = values;
        }

        public Enum get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            short word = Struct.this.getByteBuffer().getShort(index);
            return this._values[this.get(2, word)];
        }

        public void set(Enum e) {
            int value = e.ordinal();
            if (this._values[value] != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            int index = Struct.this.getByteBufferPosition() + this.offset();
            short word = Struct.this.getByteBuffer().getShort(index);
            Struct.this.getByteBuffer().putShort(index, (short)this.set(value, 2, word));
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Enum8<T extends Enum>
    extends Member {
        private final Enum[] _values;

        public Enum8(Enum[] values) {
            super(8, 1);
            this._values = values;
        }

        public Enum8(Enum[] values, int nbrOfBits) {
            super(nbrOfBits, 1);
            this._values = values;
        }

        public Enum get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            byte word = Struct.this.getByteBuffer().get(index);
            return this._values[this.get(1, word)];
        }

        public void set(Enum e) {
            int value = e.ordinal();
            if (this._values[value] != e) {
                throw new IllegalArgumentException("enum: " + e + ", ordinal value does not reflect enum values position");
            }
            int index = Struct.this.getByteBufferPosition() + this.offset();
            byte word = Struct.this.getByteBuffer().get(index);
            Struct.this.getByteBuffer().put(index, (byte)this.set(value, 1, word));
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Reference64<S extends Struct>
    extends Member {
        private S _struct;

        public Reference64() {
            super(64, 8);
        }

        public void set(S struct) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (struct != null) {
                Struct.this.getByteBuffer().putLong(index, ((Struct)struct).address());
            } else if (struct == null) {
                Struct.this.getByteBuffer().putLong(index, 0L);
            }
            this._struct = struct;
        }

        public S get() {
            return this._struct;
        }

        public long value() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            return Struct.this.getByteBuffer().getLong(index);
        }

        public boolean isUpToDate() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getLong(index) == ((Struct)this._struct).address();
            }
            return Struct.this.getByteBuffer().getLong(index) == 0L;
        }
    }

    public class Reference32<S extends Struct>
    extends Member {
        private S _struct;

        public Reference32() {
            super(32, 4);
        }

        public void set(S struct) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (struct != null) {
                Struct.this.getByteBuffer().putInt(index, (int)((Struct)struct).address());
            } else {
                Struct.this.getByteBuffer().putInt(index, 0);
            }
            this._struct = struct;
        }

        public S get() {
            return this._struct;
        }

        public int value() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            return Struct.this.getByteBuffer().getInt(index);
        }

        public boolean isUpToDate() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this._struct != null) {
                return Struct.this.getByteBuffer().getInt(index) == (int)((Struct)this._struct).address();
            }
            return Struct.this.getByteBuffer().getInt(index) == 0;
        }
    }

    public class Float64
    extends Member {
        public Float64() {
            super(64, 8);
        }

        public double get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            return Struct.this.getByteBuffer().getDouble(index);
        }

        public void set(double value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            Struct.this.getByteBuffer().putDouble(index, value);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Float32
    extends Member {
        public Float32() {
            super(32, 4);
        }

        public float get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            return Struct.this.getByteBuffer().getFloat(index);
        }

        public void set(float value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            Struct.this.getByteBuffer().putFloat(index, value);
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class BitField
    extends Member {
        public BitField(int nbrOfBits) {
            super(nbrOfBits, 0);
        }

        public long longValue() {
            long signedValue = Struct.this.readBits(this.bitIndex() + (this.offset() << 3), this.bitLength());
            return (-1L << this.bitLength() ^ 0xFFFFFFFFFFFFFFFFL) & signedValue;
        }

        public int intValue() {
            return (int)this.longValue();
        }

        public short shortValue() {
            return (short)this.longValue();
        }

        public byte byteValue() {
            return (byte)this.longValue();
        }

        public void set(long value) {
            Struct.this.writeBits(value, this.bitIndex() + (this.offset() << 3), this.bitLength());
        }

        public String toString() {
            return String.valueOf(this.longValue());
        }
    }

    public class Signed64
    extends Member {
        public Signed64() {
            super(64, 8);
        }

        public Signed64(int nbrOfBits) {
            super(nbrOfBits, 8);
        }

        public long get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            long word = Struct.this.getByteBuffer().getLong(index);
            return this.bitLength() == 64 ? word : this.get(8, word);
        }

        public void set(long value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 64) {
                Struct.this.getByteBuffer().putLong(index, value);
            } else {
                Struct.this.getByteBuffer().putLong(index, this.set(value, 8, Struct.this.getByteBuffer().getLong(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Unsigned32
    extends Member {
        public Unsigned32() {
            super(32, 4);
        }

        public Unsigned32(int nbrOfBits) {
            super(nbrOfBits, 4);
        }

        public long get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().getInt(index);
            return 0xFFFFFFFFL & (long)(this.bitLength() == 32 ? word : this.get(4, word));
        }

        public void set(long value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 32) {
                Struct.this.getByteBuffer().putInt(index, (int)value);
            } else {
                Struct.this.getByteBuffer().putInt(index, this.set((int)value, 4, Struct.this.getByteBuffer().getInt(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Signed32
    extends Member {
        public Signed32() {
            super(32, 4);
        }

        public Signed32(int nbrOfBits) {
            super(nbrOfBits, 4);
        }

        public int get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().getInt(index);
            return this.bitLength() == 32 ? word : this.get(4, word);
        }

        public void set(int value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 32) {
                Struct.this.getByteBuffer().putInt(index, value);
            } else {
                Struct.this.getByteBuffer().putInt(index, this.set(value, 4, Struct.this.getByteBuffer().getInt(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Unsigned16
    extends Member {
        public Unsigned16() {
            super(16, 2);
        }

        public Unsigned16(int nbrOfBits) {
            super(nbrOfBits, 2);
        }

        public int get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().getShort(index);
            return this.bitLength() == 16 ? word : this.get(2, word);
        }

        public void set(int value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 16) {
                Struct.this.getByteBuffer().putShort(index, (short)value);
            } else {
                Struct.this.getByteBuffer().putShort(index, (short)this.set(value, 2, Struct.this.getByteBuffer().getShort(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Signed16
    extends Member {
        public Signed16() {
            super(16, 2);
        }

        public Signed16(int nbrOfBits) {
            super(nbrOfBits, 2);
        }

        public short get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().getShort(index);
            return (short)(this.bitLength() == 16 ? word : this.get(2, word));
        }

        public void set(short value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 16) {
                Struct.this.getByteBuffer().putShort(index, value);
            } else {
                Struct.this.getByteBuffer().putShort(index, (short)this.set(value, 2, Struct.this.getByteBuffer().getShort(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Unsigned8
    extends Member {
        public Unsigned8() {
            super(8, 1);
        }

        public Unsigned8(int nbrOfBits) {
            super(nbrOfBits, 1);
        }

        public short get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().get(index);
            return (short)(this.bitLength() == 8 ? word : this.get(1, word));
        }

        public void set(short value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 8) {
                Struct.this.getByteBuffer().put(index, (byte)value);
            } else {
                Struct.this.getByteBuffer().put(index, (byte)this.set(value, 1, Struct.this.getByteBuffer().get(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Signed8
    extends Member {
        public Signed8() {
            super(8, 1);
        }

        public Signed8(int nbrOfBits) {
            super(nbrOfBits, 1);
        }

        public byte get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().get(index);
            return (byte)(this.bitLength() == 8 ? word : this.get(1, word));
        }

        public void set(byte value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 8) {
                Struct.this.getByteBuffer().put(index, value);
            } else {
                Struct.this.getByteBuffer().put(index, (byte)this.set(value, 1, Struct.this.getByteBuffer().get(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class Bool
    extends Member {
        public Bool() {
            super(8, 1);
        }

        public Bool(int nbrOfBits) {
            super(nbrOfBits, 1);
        }

        public boolean get() {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            int word = Struct.this.getByteBuffer().get(index);
            word = this.bitLength() == 8 ? word : this.get(1, word);
            return word != 0;
        }

        public void set(boolean value) {
            int index = Struct.this.getByteBufferPosition() + this.offset();
            if (this.bitLength() == 8) {
                Struct.this.getByteBuffer().put(index, (byte)(value ? -1 : 0));
            } else {
                Struct.this.getByteBuffer().put(index, (byte)this.set(value ? -1 : 0, 1, Struct.this.getByteBuffer().get(index)));
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }
    }

    public class UTF8String
    extends Member {
        private final UTF8ByteBufferWriter _writer;
        private final UTF8ByteBufferReader _reader;
        private final int _length;

        public UTF8String(int length) {
            super(length << 3, 1);
            this._writer = new UTF8ByteBufferWriter();
            this._reader = new UTF8ByteBufferReader();
            this._length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String string) {
            ByteBuffer buffer;
            ByteBuffer byteBuffer = buffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    int index = Struct.this.getByteBufferPosition() + this.offset();
                    buffer.position(index);
                    this._writer.setOutput(buffer);
                    if (string.length() < this._length) {
                        this._writer.write(string);
                        this._writer.write(0);
                    } else if (string.length() > this._length) {
                        this._writer.write(string.substring(0, this._length));
                    } else {
                        this._writer.write(string);
                    }
                }
                catch (IOException e) {
                    throw new Error(e.getMessage());
                }
                finally {
                    this._writer.reset();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String get() {
            ByteBuffer buffer;
            ByteBuffer byteBuffer = buffer = Struct.this.getByteBuffer();
            synchronized (byteBuffer) {
                TextBuilder tmp = TextBuilder.newInstance();
                try {
                    int index = Struct.this.getByteBufferPosition() + this.offset();
                    buffer.position(index);
                    this._reader.setInput(buffer);
                    for (int i = 0; i < this._length; ++i) {
                        char c = (char)this._reader.read();
                        if (c == '\u0000') {
                            String string = tmp.toString();
                            return string;
                        }
                        tmp.append(c);
                    }
                    String string = tmp.toString();
                    return string;
                }
                catch (IOException e) {
                    throw new Error(e.getMessage());
                }
                finally {
                    this._reader.reset();
                    TextBuilder.recycle(tmp);
                }
            }
        }

        public String toString() {
            return this.get();
        }
    }

    protected class Member {
        private final int _offset;
        private final int _bitIndex;
        private final int _bitLength;

        protected Member(int bitLength, int wordSize) {
            this._bitLength = bitLength;
            if (Struct.this._resetIndex) {
                Struct.this._index = 0;
            }
            if (wordSize == 0 || bitLength != 0 && wordSize == Struct.this._wordSize && Struct.this._bitsUsed + bitLength <= wordSize << 3) {
                this._offset = Struct.this._index - Struct.this._wordSize;
                this._bitIndex = Struct.this._bitsUsed;
                Struct.this._bitsUsed += bitLength;
                while (Struct.this._bitsUsed > Struct.this._wordSize << 3) {
                    Struct.this._index++;
                    Struct.this._wordSize++;
                    Struct.this._size = MathLib.max(Struct.this._size, Struct.this._index);
                }
                return;
            }
            if (!Struct.this.isPacked()) {
                int misaligned;
                if (Struct.this._alignment < wordSize) {
                    Struct.this._alignment = wordSize;
                }
                if ((misaligned = Struct.this._index % wordSize) != 0) {
                    Struct.this._index += wordSize - misaligned;
                }
            }
            this._offset = Struct.this._index;
            this._bitIndex = 0;
            Struct.this._index += MathLib.max(wordSize, bitLength + 7 >> 3);
            Struct.this._wordSize = wordSize;
            Struct.this._bitsUsed = bitLength;
            Struct.this._size = MathLib.max(Struct.this._size, Struct.this._index);
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final int offset() {
            return this._offset;
        }

        public final int bitIndex() {
            return this._bitIndex;
        }

        public final int bitLength() {
            return this._bitLength;
        }

        final int get(int wordSize, int word) {
            int shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? (wordSize << 3) - this.bitIndex() - this.bitLength() : this.bitIndex();
            int mask = -1 >>> 32 - this.bitLength();
            return (word >>= shift) & mask;
        }

        final int set(int value, int wordSize, int word) {
            int shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? (wordSize << 3) - this.bitIndex() - this.bitLength() : this.bitIndex();
            int mask = -1 >>> 32 - this.bitLength();
            return word & ~(mask <<= shift) | (value <<= shift) & mask;
        }

        final long get(int wordSize, long word) {
            int shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? (wordSize << 3) - this.bitIndex() - this.bitLength() : this.bitIndex();
            long mask = -1L >>> 64 - this.bitLength();
            return (word >>= shift) & mask;
        }

        final long set(long value, int wordSize, long word) {
            int shift = Struct.this.byteOrder() == ByteOrder.BIG_ENDIAN ? (wordSize << 3) - this.bitIndex() - this.bitLength() : this.bitIndex();
            long mask = -1L >>> 64 - this.bitLength();
            return word & ((mask <<= shift) ^ 0xFFFFFFFFFFFFFFFFL) | (value <<= shift) & mask;
        }
    }
}

