
namespace License {

  /**
   * @brief ライセンスをチェックする関数
   * @param lic ライセンスファイル名
   * @return 0 認証完了
   * @return 1 ライセンスファイルが見つかりません
   * @return 2 公開鍵が不正です
   * @return 3 ライセンスファイルが不正です
   * @return 4 ライセンス期限が過ぎています
   * @return 5 このマシンにはライセンスされていません
   * @return 6 バイナリが改ざんされています
  */
  int check_license(char *lic);

  /**
   * @brief BASE64にエンコード
   * @param input 入力データ
   * @param length データ長（バイト数）
   * @return エンコードされた文字列へのポインタ
   */
  char *base64(const unsigned char *input, int length);

  /**
   * @brief BASE64をデコード
   * @param input 入力データ
   * @param length データ長（バイト数）
   * @param buff 出力
   * @return デコードされたデータ長（バイト数）
   */
  int unbase64(unsigned char *input, int length, char *buff);

  /**
   * @brief マシン情報（SHA1ハッシュ）を取得する
   * @param disp マシン情報を表示するかどうか
   * @return SHA1の文字列
   */
  char *get_digest(bool disp=false);

  int check_license(char *lic)
  {
    ifstream mf(lic);
    if (!mf.is_open()) return 1;
    
    // 公開鍵の読み込み
    // include here
    stringstream ss;
    for (int i=0; i<NB; i++) ss << s0.substr(ix[i]*BS, BS);
    string buff=ss.str();
    ss.str(""); ss.clear();
    ss << "-----BEGIN RSA PUBLIC KEY-----" << endl;
    for (int i=0; i<LEN/64+1; i++) {
      ss << buff.substr(i*64, 64) << endl;
    }      
    ss << "-----END RSA PUBLIC KEY-----";
    buff=ss.str();
    BIO *bio=BIO_new_mem_buf((void*)buff.c_str(), -1);
    RSA *PubKey=PEM_read_bio_RSAPublicKey(bio, NULL, NULL, NULL);
    BIO_free(bio);
    if (PubKey == NULL) {
      return 2;
    }

    // 冒頭のコメント行を飛ばす
    string line;
    while (getline(mf, line)) {
      if (line[0] != '#') break;
    }

    // バッファの確保
    char *xx=new char [999];
    char *yy=new char [999];

    // BASE64デコード　RSA複合
    buff=line+"\n";
    for (int i=0; i<5; i++) {
      getline(mf,line);
      buff=buff+line+"\n";
    }
    int l=unbase64( (unsigned char*)buff.c_str(), buff.length(), xx);
    int outlen=RSA_public_decrypt(l, (const unsigned char *)xx, (unsigned char *)yy, PubKey, RSA_PKCS1_PADDING);
    yy[outlen]='\0';

    // ノード数、終了期日
    char *p=strtok(yy, " ");
    int nodes=0, year=0, month=0, day=0;
    sscanf(p, "%d/%d/%d/%d", &nodes, &year, &month, &day);
    //cout << p << endl;

    // バイナリダイジェスト
    p=strtok(NULL, " ");
    char *digest0=new char[99];
    strncpy(digest0, p, 40);
    digest0[40]='\0';
    //cout << p << endl;

    // ソルト
    p=strtok(NULL, " ");
    char *salt0=new char[99];
    strncpy(salt0, p, 40);
    salt0[40]='\0';
    //cout << p << endl;

    // ライセンスチェック
    if (nodes == 0 || year == 0 || month == 0 || day == 0) return 3;

    // バイナリ改ざんチェック
    // 自分自身のファイル名を取得
    l=readlink("/proc/self/exe", xx, 998);
    xx[l]='\0';
    
    ifstream myself(xx);
    if (!myself.is_open()) {
      return 6;
    }

    // 自分自身のファイルのダイジェストを計算（SHA-1）
    unsigned char digest[20];
    SHA_CTX c;
    SHA1_Init(&c);
    while (myself.eof() != true) {
      myself.read(xx, 999);
      SHA1_Update(&c, xx, myself.gcount());
    }
    SHA1_Final(digest, &c);
    myself.close();
    
    // バイナリ改ざんチェック
    for (int i=0; i<20; i++) sprintf(&xx[2*i], "%02x", digest[i]);
    xx[40]='\0';
    if (strcmp(digest0,xx) != 0) {
      return 6;
    }

    // ライセンスの期間チェック
    time_t jikoku;
    struct tm *lt;
    /* get localtime */
    time(&jikoku); lt=localtime(&jikoku);
    /* check expiration date */
    int k=0;
    if (lt->tm_year+1900 > year) {
      k++;
    }
    else if (lt->tm_year+1900 == year) {
      if (lt->tm_mon+1 > month) {
	k++;
      }
      else if (lt->tm_mon+1 == month) {
	if (lt->tm_mday > day) {
	  k++;
	}
      }
    }
    if (k > 0) return 4;

    // 動作しているマシンがライセンスされているかのチェック
    char *salt=new char[99];
    for (int j=0; j<nodes; j++) {
      buff.clear();
      // BASE64デコード　RSA複合
      for (int i=0; i<6; i++) {
	getline(mf,line);
	buff=buff+line+"\n";
      }
      l=unbase64( (unsigned char*)buff.c_str(), buff.length(), xx);
      outlen=RSA_public_decrypt(l, (const unsigned char *)xx, (unsigned char *)yy, PubKey, RSA_PKCS1_PADDING);
      yy[outlen]='\0';

      // マシン情報のハッシュ値
      p=strtok(yy, " ");
      strncpy(xx, p, 40);
      xx[40]='\0';

      // ソルト
      p=strtok(NULL, " ");
      strncpy(salt, p, 40);
      salt[40]='\0';

      // マシン情報のハッシュ値がunlimitedならば無条件でOK
      if (strcmp(xx, "unlimited") == 0 && strcmp(salt, salt0) == 0) {
	delete [] xx;
	delete [] yy;
	delete [] salt0;
	delete [] salt;
	delete [] digest0;
	return 0;
      }

      // マシン情報のハッシュ値を取得して比較
      p=get_digest();
      if (strcmp(xx,p) == 0 && strcmp(salt, salt0) == 0) {
	delete [] xx;
	delete [] yy;
	delete [] salt0;
	delete [] salt;
	delete [] digest0;
	return 0;
      }
    }

    return 5;
  }

  char *base64(const unsigned char *input, int length)
  {
    BIO *bmem, *b64;
    BUF_MEM *bptr;
    b64 = BIO_new(BIO_f_base64());
    bmem = BIO_new(BIO_s_mem());
    b64 = BIO_push(b64, bmem);
    BIO_write(b64, input, length);
    BIO_flush(b64);
    BIO_get_mem_ptr(b64, &bptr);
    char *buff=new char[bptr->length];
    memcpy(buff, bptr->data, bptr->length-1);
    buff[bptr->length-1] = 0;
    BIO_free_all(b64);
    
    return buff;
  }

  int unbase64(unsigned char *input, int length, char *buff)
  {
    BIO *b64, *bmem;
    memset(buff, 0, length);
    b64 = BIO_new(BIO_f_base64());
    bmem = BIO_new_mem_buf(input, length);
    bmem = BIO_push(b64, bmem);
    int l=BIO_read(bmem, buff, length);
    BIO_free_all(bmem);

    return l;
  }

  char *get_digest(bool disp)
  {
    string minfo;
    stringstream ss;

    // hardware uuid
    /* uuid
    {
      FILE *pp=popen("sudo -n dmidecode -s system-uuid", "r");
      if (pp != NULL) {
	char *line=new char[999];
	fgets(line, 999, pp);
	int status=pclose(pp);
	if (status == 0) {
	  ss << line;
	}
	else {
	  cerr << "please add a line of \"ALL ALL=(ALL) NOPASSWD: /usr/sbin/dmidecode\" at the end of /etc/sudoers" << endl;
	  exit(1);
	}
	delete [] line;
      }
    }
    uuid */

    // MAC address
    {
      DIR *dir;
      struct dirent *dp;

      if ( (dir=opendir("/sys/class/net")) == NULL ) {
	cout << "Error" << endl;
	exit(1);
      }

      vector<string> dlist;
      for (dp=readdir(dir); dp!=NULL; dp=readdir(dir)) {
	dlist.push_back(string(dp->d_name));
      }
      closedir(dir);
      sort(dlist.begin()+2, dlist.end());  
      
      string tmp;
      for (int i=2; i<dlist.size(); i++) {
	string net_dir="/sys/class/net/" + dlist[i];
	string type = net_dir + "/type";
	ifstream ifs1(type.c_str());
	if (!ifs1.is_open()) continue;
	getline(ifs1, tmp);
	int x=atoi(tmp.c_str());
	if (x == 1) {
	  string address = net_dir + "/address";
	  ifstream ifs2(address.c_str());
	  if (!ifs2.is_open()) continue;
	  getline(ifs2,tmp);
	  ss << tmp << endl;
	}
      }
    }
    
    // CPU
    {
      ifstream ifs("/proc/cpuinfo");
      if (!ifs.is_open()) {
	cout << "Error" << endl;
	exit(1);
      }

      string tmp,tmp2;
      string processor, vendor_id, cpu_family, model, model_name, stepping;
      while (true) {
	getline(ifs,tmp);
	if (ifs.eof()) break;
	tmp2=tmp;
	string::size_type ix=tmp2.find_first_of(':');
	if (ix != string::npos) tmp2.erase(ix);
	if ( tmp2.find("processor",0) != string::npos ) processor=tmp;
	else if ( tmp2.find("vendor_id",0) != string::npos ) vendor_id=tmp;
	else if ( tmp2.find("cpu family",0) != string::npos ) cpu_family=tmp;
	else if ( tmp2.find("model name",0) != string::npos ) model_name=tmp;
	else if ( tmp2.find("model",0) != string::npos ) model=tmp;
	else if ( tmp2.find("stepping",0) != string::npos ) stepping=tmp;
      }
      ss << processor << endl;
      ss << vendor_id << endl;
      ss << cpu_family << endl;
      ss << model << endl;
      ss << model_name << endl;
      ss << stepping << endl;
    }

    minfo=ss.str();
    if (disp) cout << minfo << endl;

    unsigned char digest[20];
    SHA_CTX c;
    SHA1_Init(&c);
    SHA1_Update(&c, minfo.c_str(), minfo.length());
    SHA1_Final(digest, &c);
    char *hex=new char[41];
    for (int i=0; i<20; i++) sprintf(&hex[2*i], "%02x", digest[i]);
    hex[40]='\0';

    return hex;
  }

}

