#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <ctime>
#include <string>
#include <cstring>
#include <vector>
#include <stack>
#include <queue>
#include <algorithm>
#include <cmath>
#include <fstream>
#include <sstream>

#include <unistd.h>

using namespace std;

#define BS 4

void write_scrambled_key(string fname_pubkey);

void print_usage(void)
{
  printf("mk_header [options] <file> <public>\n");
  printf("    file\tpre_l-tools.hppを指定する\n");
  printf("    public\t公開鍵ファイル\n");
  printf("\n");
  printf("options:\n");
  printf("  -u       : システムのUUIDを参照する\n");
}

int main(int argc, char *argv[])
{
  srand((unsigned)time(NULL));
  
  int _u=0;
  int c;
  while((c=getopt(argc, argv, "u")) != -1){
    switch (c){
    case 'u':
      _u=1;
      break;
    default:
      print_usage();
      exit(1);
    }
  }

  if ((argc-optind) != 2) {
    print_usage();
    exit(1);
  }

  string headerfile=string(argv[optind++]);
  string publickey=string(argv[optind++]);

  ifstream ifs(headerfile.c_str());
  if (!ifs.is_open()) {
    cerr << "file not found" << endl;
    exit(1);
  }

  string line;
  while (getline(ifs, line)) {
    if (line.find("// include here",0) != string::npos) {
      write_scrambled_key(publickey);
    }
    else {
      if (_u == 1) {
	if (line.find("/* uuid",0) != string::npos) continue;
	if (line.find("uuid */",0) != string::npos) continue;
      }
      cout << line << "\n";
    }
  }

}

void write_scrambled_key(string fname_pubkey)
{
  ifstream ifs(fname_pubkey.c_str());
  if (!ifs.is_open()) {
    cerr << "file not found" << endl;
    exit(1);
  }
  
  string line;
  stringstream ss;
  while (getline(ifs, line)) {
    if (line.find("-BEGIN RSA PUBLIC KEY-",0) != string::npos) break;
  }
  while (getline(ifs, line)) {
    if (line.find("-END RSA PUBLIC KEY-",0) != string::npos) break;
    ss << line;
  }
  string PubKey1=ss.str();
  const int LEN=PubKey1.size();
  const int NB=LEN/BS;

  vector< pair<int, int> > aa;
  for (int i=0; i<NB; i++) aa.push_back( pair<int, int>(rand(), i) );
  sort(aa.begin(), aa.end());
  for (int i=0; i<NB; i++) aa[i].first=i;
  
  ss.str(""); ss.clear();
  for (int i=0; i<NB; i++) ss << PubKey1.substr(aa[i].second*BS, BS);
  string PubKey2=ss.str();
  
  for (int i=0; i<NB; i++) swap(aa[i].first, aa[i].second);
  sort(aa.begin(), aa.end());
  
  // output
  cout << "const int BS=" << BS << ";" << endl;
  cout << "const int NB=" << NB << ";" << endl;
  cout << "const int LEN=" << LEN << ";" << endl;
  cout << "int ix[" << NB << "]={";
  for (int i=0; i<NB; i++) {
    if (i%20 == 0) cout << endl;
    cout << aa[i].second;
    if (i != NB-1) cout << ", ";
  }
  cout << endl << "};" << endl;

  cout << "string s0;" << endl;
  for (int i=0; i<LEN/64+1; i++) {
    cout << "s0=s0+\"" << PubKey2.substr(i*64, 64) << "\";" << endl;
  }
  
  /*
  ss.str(""); ss.clear();
  for (int i=0; i<NB; i++) ss << PubKey2.substr(aa[i].second*BS, BS);
  string PubKey3=ss.str();
  cout << endl;
  cout << PubKey1 << endl;
  cout << PubKey2 << endl;
  cout << PubKey3 << endl;
  */
}

