#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <ctime>
#include <string>
#include <cstring>
#include <vector>
#include <stack>
#include <queue>
#include <algorithm>
#include <cmath>
#include <fstream>
#include <sstream>
#include <unistd.h>

#include <openssl/rsa.h>
#include <openssl/sha.h>
#include <openssl/pem.h>
#include <openssl/bio.h>

#define MAXLEN 999

using namespace std;

void print_usage(void)
{
  printf("l-keygen <digest> <minfo> <date> <private> \n");
  printf("    <digest>   SHA-1 message digest of executable file \n");
  printf("    <minfo>    machine informations file \n");
  printf("    <date>     expiration date (e.g. 2000/12/31) \n");
  printf("    <private>  private key file \n");
  printf("\n");
  exit(0);
}

char *base64(const unsigned char *input, int length);

int main(int argc,char *argv[])
{
  srand((unsigned)time(NULL));
  if (argc != 5) {
    print_usage();
    return 0;
  }

  string digest=string(argv[1]);
  string minfofile=string(argv[2]);
  string exdate=string(argv[3]);
  string keyfile=string(argv[4]);

  ifstream mf(minfofile.c_str());
  if (!mf.is_open()) {
    cout << minfofile << " : file not found" << endl;
    exit(1);
  }

  // ライセンスするマシンのノード数を数える
  int nodes=0;
  string line;
  while (getline(mf,line)) nodes++;
  mf.clear();
  mf.seekg(0);
  
  cout << "# expiration date: " << exdate << endl;

  // 公開鍵の読み込み
  RSA *PriKey;
  FILE *pkf=fopen(keyfile.c_str(), "r");
  if (pkf == NULL) {
    cerr << keyfile << " : file not found" << endl;
    exit(1);
  }
  PriKey=PEM_read_RSAPrivateKey(pkf, NULL, NULL, NULL);
  if (PriKey == NULL) {
    cerr << "cannot read Private Key" << endl;
    exit(1);
  }
  fclose(pkf);
  //cout << RSA_size(PriKey)-11 << endl;

  // ソルト（40文字）をランダムに発生
  char *salt=new char[99];
  for (int i=0; i<40; i++) salt[i]=(char)(33+rand()%94);
  salt[40]='\0';

  // ノード数、有効期限、バイナリのハッシュ値、ソルト を秘密鍵で暗号化
  char *q=new char[MAXLEN];
  char *p=new char[MAXLEN];
  sprintf(p, "%d/%s %s %s", nodes, exdate.c_str(), digest.c_str(), salt);
  int olen=RSA_private_encrypt(strlen(p), (const unsigned char *)p, (unsigned char *)q, PriKey, RSA_PKCS1_PADDING);
  char *xx=base64((const unsigned char *)q, olen);
  cout << xx << endl;
  delete [] xx;

  // マシンのハッシュ値、ソルト を秘密鍵で暗号化
  while (getline(mf,line)) {
    line=line+" "+string(salt);
    int olen2=RSA_private_encrypt(line.length(), (const unsigned char *)line.c_str(), (unsigned char *)q, PriKey, RSA_PKCS1_PADDING);
    char *r=base64((const unsigned char *)q, olen2);
    cout << r << endl;
    delete [] r;
  }

  delete [] salt;
  delete [] p;
  delete [] q;

}

char *base64(const unsigned char *input, int length)
{
  BIO *bmem, *b64;
  BUF_MEM *bptr;
  b64 = BIO_new(BIO_f_base64());
  bmem = BIO_new(BIO_s_mem());
  b64 = BIO_push(b64, bmem);
  BIO_write(b64, input, length);
  BIO_flush(b64);
  BIO_get_mem_ptr(b64, &bptr);
  char *buff=new char[bptr->length];
  memcpy(buff, bptr->data, bptr->length-1);
  buff[bptr->length-1] = 0;
  BIO_free_all(b64);
  
  return buff;
}
