﻿using System;
using com.andoutomo.kybernetes.view;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.command;
using System.Reflection;
using System.Collections.Generic;

namespace com.andoutomo.kybernetes.control
{
    public class CmdDispatcher
    {
        #region Singleton Setting
        private static CmdDispatcher singleton;
        private CmdDispatcher()
        {
        }
        public static CmdDispatcher getDispatcher(BaseForm form)
        {
            if (singleton == null)
            {
                singleton = new CmdDispatcher(form);
            }
            return singleton;
        }

        private BaseForm baseForm;

        private CmdDispatcher(BaseForm form)
        {
            form.onCmdDispatch += new BaseForm.CmdDispatchEventHandler(form_onCmdDispatch);
            this.baseForm = form;
            
        }
        public BaseForm getForm()
        {
            return this.baseForm;
        }

        private void form_onCmdDispatch(object sender, CmdDispatchEventArg e)
        {
            e.Result = dispatch(e.Command);
        }

        #endregion
        /// <summary>
        /// コマンドをデータベースと照合して、処理の呼び出しを実施します。
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public string dispatch(string command)
        {
            //空文字の場合は改行を入れる(Unixの仕様に準拠)
            if (string.IsNullOrEmpty(command))
            {
                return string.Empty;
            }

            string retStr = string.Empty;
            string commandTop = command.Split(' ')[0];
            CommandData data = CommandDataAccessor.getObject.getCommandData(commandTop);

            if (data != null)
            {
                try
                {
                    List<SimpleDataBean> dllList = CommandDataAccessor.getObject.getDllList();

                    Assembly asm;
                    Type argsType = null;
                    Type commandType = null;
                    foreach (SimpleDataBean bean in dllList)
                    {
                        asm = Assembly.LoadFrom(bean.Val);
                        if (argsType == null)
                        {
                            argsType = asm.GetType(data.ArgClass);
                        }
                        if (commandType == null)
                        {
                            commandType = asm.GetType(data.TargetClass);
                        }
                        //両方見つかったら脱出。
                        if (argsType != null && commandType != null)
                        {
                            break;
                        }
                    }
                    if (argsType == null || commandType == null)
                    {
                        return "コマンドが見つかりません。";
                    }
                    CommandArg args = (CommandArg)Activator.CreateInstance(argsType);
                    AbCommand commandCls = (AbCommand)Activator.CreateInstance(commandType);

                    args.split(command);
                    commandCls.run(args,baseForm);

                    retStr = commandCls.getMessage();
                }
                catch (Exception e)
                {
                    retStr = "エラーが発生しました。";
                    new KybernetesApplicationException(e);
                }
            }
            else
            {
                retStr = "不明なコマンドです。";
            }
            return retStr;
        }
    }
}
