﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.andoutomo.kybernetes.view
{
    /// <summary>
    /// コマンドヒストリを保持します。
    /// </summary>
    public class CmdHistory
    {
        private string[] commandHist;
        private int currentPosition;
        const int MAXHIST = 10; 

        public CmdHistory()
        {
            commandHist = new string[MAXHIST];
            currentPosition = 0;
        }
        /// <summary>
        /// 直前に実行されたコマンドをを提示します。
        /// 同時にカレント位置を動かし、さらにその前のコマンドを提示する準備を行います。
        /// </summary>
        /// <returns></returns>
        public string prevCommand()
        {
            //終点まで来ている場合は最後のコマンドを表示。カレント位置も動かさない。
            if (currentPosition == MAXHIST)
            {
                return commandHist[MAXHIST-1];
            }
            //次に提示するコマンドがある場合は、カレント位置を動かす。
            if (!string.IsNullOrEmpty(commandHist[currentPosition]))
            {
                currentPosition++;
            }
            //ヒストリ配列からコマンドを取得してreturn
            if (currentPosition > 0)
            {
                return commandHist[currentPosition - 1];
            }
            //この段階でcurrentPosition=0(ヒストリがない)場合は、空文字を返す。
            else
            {
                return string.Empty;
            }
        }
        /// <summary>
        /// カレント位置の次に実行されたコマンドを提示します。
        /// </summary>
        /// <returns></returns>
        public string nextCommand()
        {
            currentPosition--;
            if (currentPosition <= 0)
            {
                currentPosition = 0;
                return string.Empty;
            }
            return commandHist[currentPosition-1];
        }
        /// <summary>
        /// コマンド受け入れを行います。
        /// コマンドはスタックされ、10件以上の場合は10番目が破棄されます。
        /// また、同一のコマンドを連続入力した場合はスタックを行いません。
        /// </summary>
        /// <param name="command"></param>
        public void stackCmd(string command)
        {
            if (command != commandHist[0])
            {
                //スタックを行う
                for (int i = MAXHIST-1; i > 0; i--)
                {
                    commandHist[i] = commandHist[i - 1];
                }

                //新たなコマンドを追加する
                commandHist[0] = command;
            }
            //ポジションをリセット
            resetPosition();
        }
        /// <summary>
        /// ヒストリで参照するポジションをリセットします。
        /// </summary>
        public void resetPosition()
        {
            currentPosition = 0;
        }
    }
}
