﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using com.andoutomo.kybernetes.control;
using com.andoutomo.kybernetes.data.DAO;
using System.Drawing;
using com.andoutomo.kybernetes.data.accessor;
using System.Runtime.InteropServices;


namespace com.andoutomo.kybernetes.view
{
    public partial class BaseForm : Form
    {
        public BaseForm()
        {
            InitializeComponent();

            List<string> initialText = new List<string>();
            initialText.Add("#####################################################");
            initialText.Add("# " + AppInfoContainer.Title + " " + AppInfoContainer.Description);
            initialText.Add("# Version " + AppInfoContainer.VersionNo);
            initialText.Add("# " + AppInfoContainer.CopyRight);
            initialText.Add("# ");
            initialText.Add("#####################################################");
            addMultiText(initialText);

            addPrompt();
            history = new CmdHistory();

            this.Text = AppInfoContainer.Title + " " + AppInfoContainer.Description;
            Echo = true;
            txtInput.Focus();
        }
        private CmdHistory history;

        /// <summary>
        /// カテゴリ設定ダイアログを表示します。
        /// </summary>
        /// <param name="arg"></param>
        public void invokeCategSettingDialog(List<CategoryData> arg)
        {
            CategorySetting categSetting = new CategorySetting();
            categSetting.StartPosition = FormStartPosition.CenterParent;
            categSetting.setCategoryList(arg);
            categSetting.ShowDialog();
        }

        /// <summary>
        /// バージョン情報を表示します
        /// </summary>
        public void invokeCreditDialog()
        {
            Credit creditForm = new Credit();
            creditForm.StartPosition = FormStartPosition.CenterParent;
            
            creditForm.ShowDialog();
        }
        /// <summary>
        /// エクスポート用のファイルダイアログを開いて選択したファイルパスを返します。
        /// </summary>
        /// <returns></returns>
        public string invokeExpDialog()
        {
            DialogResult result =this.expData.ShowDialog();
            if (result == DialogResult.OK)
            {
                return this.expData.FileName;
            }
            else
            {
                return string.Empty;
            }
        }
        /// <summary>
        /// ダンプ用のファイルダイアログを開いて選択したファイルパスを返します。
        /// </summary>
        /// <returns></returns>
        public string invokeDmpDialog()
        {
            DialogResult result = this.dmpData.ShowDialog();
            if (result == DialogResult.OK)
            {
                return this.dmpData.FileName;
            }
            return string.Empty;
        }
        /// <summary>
        /// バッチ呼び出しダイアログを呼び出します。
        /// </summary>
        /// <returns></returns>
        public string invokeShellDialog()
        {
            
            DialogResult result = this.selSh.ShowDialog();
            if (result == DialogResult.OK)
            {
                return this.selSh.FileName;
            }
            return string.Empty;
        }

        /// <summary>
        /// タイムエリア設定画面を表示します。
        /// </summary>
        /// <param name="arg"></param>
        public void invokeTimeareaSettingDialog(List<TimeAreaData> arg)
        {
            TimeAreaSetting setting = new TimeAreaSetting();
            setting.StartPosition = FormStartPosition.CenterParent;
            setting.setTimeareaList(arg);
            setting.ShowDialog();
        }

        /// <summary>
        /// コンソールに文字列を表示します。
        /// </summary>
        /// <param name="args">表示したい文字列</param>
        public void addText(string args)
        {
            rConsole.AppendText(args + System.Environment.NewLine);
            KybernetesLogger.Log.trace(args);
        }

        /// <summary>
        /// コンソールに複数文章を追加します。
        /// </summary>
        /// <param name="messages">追加したい文章群</param>
        public void addMultiText(List<string> messages)
        {
            foreach (string message in messages)
            {
                addText(message);
            }
            rConsole.AppendText(System.Environment.NewLine);
        }
        private void addPrompt()
        {
            rConsole.AppendText("> ");
        }

        public int getPanelSize()
        {
            return this.pnlTask.Width;
        }
        /// <summary>
        /// コンソールをクリアします。
        /// </summary>
        public void clearText()
        {
            rConsole.Clear();
        }

        private bool exitSwitch = false;
        public bool ExitSwitch
        {
            set { exitSwitch = value; }
        }

        private int lastRow=17;
        /// <summary>
        /// パネルを追加します。
        /// </summary>
        /// <param name="data"></param>
        public void addPanel(TaskData data)
        {
            Panel targetPanel = new PanelController(this).createRow(lastRow,data);
            
            pnlTask.Controls.Add(targetPanel);
            lastRow += targetPanel.Height-1;
        }
        /// <summary>
        /// インデックスパネルを追加します
        /// </summary>
        /// <param name="timeArea"></param>
        public void addIndexPanel(string timeArea)
        {
            Panel targetPanel = new IndexPanelController().createRow(timeArea, this.pnlTask.Width, lastRow, frColor);
            
            pnlTask.Controls.Add(targetPanel);
            lastRow += targetPanel.Height - 1;
        }


        /// <summary>
        /// パネルがダブルクリックされた時に対応します。IDをテキストボックスに転記します。
        /// </summary>
        /// <param name="data"></param>
        public void AddIDToText(string data)
        {
            this.txtInput.Text += data + " ";
            txtInput.Focus();
            this.txtInput.Select(this.txtInput.Text.Length, 0);
        }

        /// <summary>
        /// パネルをクリアします。
        /// </summary>
        public void clearPanel()
        {
            this.pnlTask.AutoScrollPosition = new Point(0, 0);

            int dummy = pnlTask.Controls.Count;
            for (int h = dummy; h > 0; h--)
            {
                Control ctrl = pnlTask.Controls[h - 1];
                
                for (int i = ctrl.Controls.Count; i > 0; i--)
                {
                    ctrl.Controls[i - 1].Dispose();
                }
                ctrl.Dispose();
            }

            pnlTask.Controls.Clear();

            //先頭行は足す
            pnlTask.Controls.Add(new CaptionPanelController().createRow(this.pnlTask.Width, frColor));
            lastRow = 17;
            
        }
        /// <summary>
        /// コマンド内容を表示するかどうかを決定します。
        /// </summary>
        public bool Echo
        {
            get;
            set;
        }
        /// <summary>
        /// コマンド入力を受け付けます。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void txtInput_KeyDown(object sender, KeyEventArgs e)
        {
            int currentYPosition;
            int currentScrollHeight = this.pnlTask.Height - 20;
            switch (e.KeyCode)
            {
                case Keys.Enter:
                    e.SuppressKeyPress = true;
                    doCommand();
                    
                    break;

                case Keys.Space:
                    if (e.Control)
                    {
                        e.SuppressKeyPress = true;
                        if (txtInput.ImeMode == ImeMode.Off)
                        {
                            txtInput.ImeMode = ImeMode.On;
                        }
                        else
                        {
                            txtInput.ImeMode = ImeMode.Off;
                        }
                    }
                    break;
                case Keys.Escape:
                    e.SuppressKeyPress = true;
                    history.resetPosition();
                    txtInput.Clear();
                    break;
                case Keys.Up:
                    e.SuppressKeyPress = true;
                    txtInput.Text = history.prevCommand();
                    txtInput.Select(this.txtInput.Text.Length, 0);
                    break;
                case Keys.Down:
                    e.SuppressKeyPress = true;
                    txtInput.Text = history.nextCommand();
                    txtInput.Select(this.txtInput.Text.Length, 0);
                    break;

                case Keys.PageDown:
                    currentYPosition = Math.Abs(this.pnlTask.AutoScrollPosition.Y);
                    this.pnlTask.AutoScrollPosition = new Point(0, currentYPosition + currentScrollHeight);

                    break;

                case Keys.PageUp:
                    currentYPosition = Math.Abs(this.pnlTask.AutoScrollPosition.Y);
                    this.pnlTask.AutoScrollPosition = new Point(0, currentYPosition - currentScrollHeight);

                    break;
            }
        }
        /// <summary>
        /// コマンドを実行します
        /// </summary>
        private void doCommand()
        {
            rConsole.Focus();
            
            if (Echo)
            {
                addText(txtInput.Text);
            }
            KybernetesLogger.Log.trace("[dispatch]" + txtInput.Text);
            
            
            string result = wkOnCmdDispatch(txtInput.Text.Trim());
            if (!string.IsNullOrEmpty(result))
            {
                addText(result);
            }

            addPrompt();
            if (!string.IsNullOrEmpty(txtInput.Text))
            {
                history.stackCmd(txtInput.Text);
            }
            txtInput.Clear();
            txtInput.ImeMode = ImeMode.Off;
            //panelResize();
            if (exitSwitch == true)
            {
                this.Close();
            }
            txtInput.Focus();
        }

        /// <summary>
        /// 文字入力ボックスを表示します。
        /// </summary>
        /// <param name="prompt"></param>
        /// <returns></returns>
        public string showInputBox(string prompt)
        {
            return this.showInputBox(prompt, string.Empty);
        }
        /// <summary>
        /// 文字入力ボックスを表示します。
        /// </summary>
        /// <param name="prompt"></param>
        /// <param name="defaultData"></param>
        /// <returns></returns>
        public string showInputBox(string prompt, string defaultData)
        {
            return showInputBox(prompt, defaultData, ImeMode.Off);
        }
        /// <summary>
        /// 文字入力ボックスを表示します。
        /// </summary>
        /// <param name="prompt"></param>
        /// <param name="defaultData"></param>
        /// <param name="imeMode"></param>
        /// <returns></returns>
        public string showInputBox(string prompt, string defaultData, ImeMode imeMode)
        {
            InputBox inputBox = new InputBox(prompt, defaultData);
            inputBox.StartPosition = FormStartPosition.CenterParent;
            inputBox.ImeMode = imeMode;
            inputBox.Owner = this;


            DialogResult res = inputBox.ShowDialog();
            if (res == DialogResult.OK)
            {
                return InputDialogData;
            }
            return null;
        }
        /// <summary>
        /// 文字入力ボックスを表示します。
        /// </summary>
        /// <param name="prompt"></param>
        /// <param name="imeMode"></param>
        /// <returns></returns>
        public string showInputBox(string prompt, ImeMode imeMode)
        {
            return showInputBox(prompt, string.Empty, imeMode);
        }

        /// <summary>
        /// 文字入力ボックスを表示します。プロンプトなし版です。
        /// </summary>
        /// <returns></returns>
        public string showInputBox()
        {
            return showInputBox("");
        }


        /// <summary>
        /// プロンプトで指定した値を(プロンプトがここに)格納します。
        /// </summary>
        public string InputDialogData
        {
            private get;
            set;
        }

        /// <summary>
        /// ドロップダウン式リストを表示します。
        /// </summary>
        /// <param name="prompt"></param>
        /// <returns></returns>
        public string showDropBoxInputBox(List<SimpleDataBean> list,string prompt)
        {
            DropBoxInputBox inputBox = new DropBoxInputBox(prompt);
            inputBox.StartPosition = FormStartPosition.CenterParent;
            inputBox.setDropData(list);

            inputBox.Owner = this;

            DialogResult res = inputBox.ShowDialog();
            if (res == DialogResult.OK)
            {
                return InputDialogData;
            }
            return null;
        }
        /// <summary>
        /// ドロップダウン式リストを表示します。デフォルト表示を追加しています。
        /// </summary>
        /// <param name="list"></param>
        /// <param name="prompt"></param>
        /// <param name="defaultData"></param>
        /// <returns></returns>
        public string showDropBoxInputBox(List<SimpleDataBean> list, string prompt, string defaultData)
        {
            DropBoxInputBox inputBox = new DropBoxInputBox(prompt,defaultData);
            inputBox.StartPosition = FormStartPosition.CenterParent;
            inputBox.setDropData(list);

            inputBox.Owner = this;

            DialogResult res = inputBox.ShowDialog();
            if (res == DialogResult.OK)
            {
                return InputDialogData;
            }
            return null;
        }

        /// <summary>
        /// マウスでコンソールをドラッグした時に、選択対象をクリップボードにコピーします。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rConsole_MouseUp(object sender, MouseEventArgs e)
        {
            Clipboard.SetDataObject(rConsole.SelectedText.Trim());
            //txtInput.Text += rConsole.SelectedText.Trim();
            txtInput.Focus();
            //選択状態を解除する
            this.txtInput.Select(this.txtInput.Text.Length, 0);
            
        }
        /// <summary>
        /// ウィンドウ全体のサイズ変更時イベントハンドラです。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void BaseForm_ResizeEnd(object sender, EventArgs e)
        {
        //    panelResize();

        }
        /// <summary>
        /// タスクパネルの大きさ調整を行います。
        /// 起動されるのは、ウィンドウ全体のサイズ変更時、及びコマンド実行時です。
        /// </summary>
        //private void panelResize()
        //{
            //rConsole.Size = new Size(this.Width - 30, this.Height / 3);
            //pnlTask.Size = new Size(this.Size.Width - 30, this.Size.Height - rConsole.Height-80);
            //rConsole.Location = new Point(5,pnlTask.Size.Height + 10);
        //}
        /// <summary>
        /// 背景色設定を呼び出します。
        /// </summary>
        public bool setPnlBackground()
        {
            DialogResult res = this.BGColorDlg.ShowDialog();
            if (res == System.Windows.Forms.DialogResult.OK)
            {
                pnlTask.BackColor = BGColorDlg.Color;
                return true;
            }
            else { return false; }
         
        }
        /// <summary>
        /// 前景色設定を呼び出します.
        /// </summary>
        /// <returns></returns>
        public bool setPnlForeground()
        {
            DialogResult res = this.FRColorDlg.ShowDialog();
            if (res == System.Windows.Forms.DialogResult.OK)
            {
                frColor = FRColorDlg.Color;
                return true;
            }
            else { return false; }
        }
        private Color frColor;
        /// <summary>
        /// スプリッターが動いた時に、入力ボックスにフォーカスを移します。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void splBase_SplitterMoved(object sender, SplitterEventArgs e)
        {
            txtInput.Focus();
        }

        /// <summary>
        /// タイマーを呼び出します。
        /// タイマーはモードレスダイアログとして表示されます。
        /// </summary>
        /// <returns></returns>
        public void showTimer(int second)
        {
            ClockForm form;
            if (second > 0)
            {
                form = new ClockForm(second * 60);
            }
            else
            {
                form = new ClockForm();
            }
            form.Owner = this;
            form.Show();
        }
        public void showTimer(int second, string title)
        {
            ClockForm form;
            if (second > 0)
            {
                form = new ClockForm(second * 60,title);
            }
            else
            {
                form = new ClockForm(title);
            }
            form.Owner = this;
            form.Show();
        }
        #region 点滅ロジック
        [DllImport("user32.dll")]
        static extern Int32 FlashWindowEx(ref FLASHWINFO pwfi);

        /// <summary>
        /// 画面点滅制御用Struct
        /// </summary>
        [StructLayout(LayoutKind.Sequential)]
        struct FLASHWINFO
        {
            public UInt32 cbSize;    // FLASHWINFO構造体のサイズ
            public IntPtr hwnd;      // 点滅対象のウィンドウ・ハンドル
            public UInt32 dwFlags;   // 以下の「FLASHW_XXX」のいずれか
            public UInt32 uCount;    // 点滅する回数
            public UInt32 dwTimeout; // 点滅する間隔（ミリ秒単位）
        }


        //private const UInt32 FLASHW_STOP = 0;        // 点滅を止める
        //private const UInt32 FLASHW_CAPTION = 1;     // タイトルバーを点滅させる
        //private const UInt32 FLASHW_TRAY = 2;        // タスクバー・ボタンを点滅させる
        private const UInt32 FLASHW_ALL = 3;         // タスクバー・ボタンとタイトルバーを点滅させる
        //private const UInt32 FLASHW_TIMER = 4;       // FLASHW_STOPが指定されるまでずっと点滅させる
        //private const UInt32 FLASHW_TIMERNOFG = 12;  // ウィンドウが最前面に来るまでずっと点滅させる

        /// <summary>
        /// タスクバーを点滅させる
        /// </summary>
        public void showAlert()
        {
            FLASHWINFO fInfo = new FLASHWINFO();
            fInfo.cbSize = Convert.ToUInt32(Marshal.SizeOf(fInfo));
            fInfo.hwnd = this.Handle;
            fInfo.dwFlags = FLASHW_ALL;
            fInfo.uCount = 5; // 点滅回数
            fInfo.dwTimeout = 0;

            FlashWindowEx(ref fInfo);
        }
        #endregion

        internal void cmdForBatch(string command)
        {
            this.addText( wkOnCmdDispatch(command));
        }


        public delegate void CmdDispatchEventHandler(object sender, CmdDispatchEventArg e);
        public event CmdDispatchEventHandler onCmdDispatch;
        string wkOnCmdDispatch(string command)
        {
            if (onCmdDispatch != null)
            {
                CmdDispatchEventArg args = new CmdDispatchEventArg();
                args.Command = command;
                
                onCmdDispatch(this, args);

                return args.Result;
            }
            else
            {
                throw new KybernetesApplicationException();
            }
        }
    }



}
