﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.connection;
using System.Data.SQLite;


namespace com.andoutomo.kybernetes.data.accessor
{
    public class TimeAreaDataAccessor
    {
        #region singleton
        private static TimeAreaDataAccessor _innerObj;
        private TimeAreaDataAccessor(){}
        public static TimeAreaDataAccessor getObject
        {
            get
            {
                if (_innerObj == null)
                {
                    _innerObj = new TimeAreaDataAccessor();
                }
                return _innerObj;
            }
        }
        #endregion

        /// <summary>
        /// タイムエリアを取得します
        /// </summary>
        /// <returns></returns>
        public List<TimeAreaData> getAllTimeArea()
        {
            List<TimeAreaData> retList = new List<TimeAreaData>();

            List<TimeAreaCalcData> wkList = getAllTimeAreaForCalc();

            foreach (TimeAreaCalcData wkData in wkList)
            {
                TimeAreaData data = (TimeAreaData)wkData;
                retList.Add(data);
            }

            //AsuradaDBConnection.getObject.selectData("SELECT TIMEAREA,START,END FROM MST_TIMEAREA", (SQLiteDataReader reader) =>
            //{
            //    while (reader.Read())
            //    {
            //        TimeAreaData data = new TimeAreaData();
            //        data.AreaStr = reader["TIMEAREA"].ToString();
            //        data.StartTime = new TimeComponent(reader["START"].ToString());
            //        data.EndTime = new TimeComponent(reader["END"].ToString());

            //        retList.Add(data);
            //    }
            //});

            return retList;
        }

        /// <summary>
        /// タイムエリアを取得します(計算用)
        /// </summary>
        /// <returns></returns>
        public List<TimeAreaCalcData> getAllTimeAreaForCalc()
        {
            List<TimeAreaCalcData> retList = new List<TimeAreaCalcData>();

            TaskDBConnection.Connection.selectData(SqlDictionary.getAllTimeArea, (SQLiteDataReader reader) =>
            {
                while (reader.Read())
                {
                    TimeAreaCalcData data = new TimeAreaCalcData();
                    data.AreaStr = reader["TIMEAREA"].ToString();
                    data.StartTime = new TimeComponent(reader["START"].ToString());
                    data.EndTime = new TimeComponent(reader["END"].ToString());

                    retList.Add(data);
                }
            });

            return retList;
        }

        /// <summary>
        /// 与えられた現時刻から該当するタイムエリアを算出します。
        /// </summary>
        /// <param name="now"></param>
        /// <returns></returns>
        public string getDefaultTimeArea(TimeComponent now)
        {
            List<object> paramList = new List<object>();
            paramList.Add(now.ToString());
            paramList.Add(now.ToString());

            string retStr = string.Empty;
            TaskDBConnection.Connection.selectData(SqlDictionary.getDefaultTimeArea, paramList,
                (SQLiteDataReader reader) =>
                {
                    if (reader.HasRows)
                    {
                        reader.Read();
                        retStr = reader["TIMEAREA"].ToString();
                    }
                });
            return retStr;
        }
    }
}
