﻿using System.Collections.Generic;
using System.Data.SQLite;
using com.andoutomo.kybernetes.data.connection;
using com.andoutomo.kybernetes.data.DAO;


namespace com.andoutomo.kybernetes.data.accessor
{
    public class CommandDataAccessor
    {
        #region singleton
        private static CommandDataAccessor accessor;
        private CommandDataAccessor()
        {
        }
        public static CommandDataAccessor getObject
        {
            get
            {
                if (accessor == null)
                {
                    accessor = new CommandDataAccessor();
                }
                return accessor;
            }
        }

        #endregion

        /// <summary>
        /// DBテーブル"tbl_command"から、呼び出すクラス名を取得する
        /// </summary>
        /// <param name="commandStr">呼び出したコマンド(引数は別)</param>
        /// <returns>コマンドデータ</returns>
        public CommandData getCommandData(string commandStr)
        {
            CommandData result = null;
            List<object> list = new List<object>();
            list.Add(commandStr);
            SettingDBConnection.Connection.selectData(CommandSqlDictionary.getCommand, list,
            (SQLiteDataReader reader) =>
            {
                if (reader.HasRows != false)
                {
                    result = new CommandData();
                    reader.Read();
                    result.TargetClass = reader["TARGETCLASS"].ToString();
                    result.ArgClass = reader["ARGCLASS"].ToString();
                    result.CmdStr = commandStr;
                }
            });
            return result;
        }

        public List<HelpData> getAllHelp()
        {
            List<HelpData> allHelp = new List<HelpData>();
            SettingDBConnection.Connection.selectData(CommandSqlDictionary.HELPALL, new List<object>(),
                (SQLiteDataReader reader)=>{
                    while (reader.Read())
                    {
                        HelpData data = new HelpData(reader["CMDSTR"].ToString(), reader["SUMMARY"].ToString());
                        allHelp.Add(data);
                    }
                });
            return allHelp;
        }
        /// <summary>
        /// 個別コマンドのヘルプを出力します。
        /// </summary>
        /// <param name="cmdStr"></param>
        /// <returns></returns>
        public HelpData getHelpData(string cmdStr)
        {
            List<object> parameters = new List<object>();
            parameters.Add(cmdStr);
            HelpData retVal =null;
            SettingDBConnection.Connection.selectData(CommandSqlDictionary.getHelp, parameters,
                (SQLiteDataReader reader) =>
                {
                    if (reader.HasRows)
                    {
                        reader.Read();
                        retVal = new HelpData(
                            reader["CMDSTR"].ToString(), 
                            reader["SUMMARY"].ToString(), 
                            reader["Detail"].ToString());
                    }
                });
            return retVal;
        }
        /// <summary>
        /// そのコマンドに紐づくアライアスを抽出します。
        /// </summary>
        /// <param name="cmdStr"></param>
        /// <returns></returns>
        public string getAlies(string cmdStr)
        {
            List<object> parameters = new List<object>();
            parameters.Add(cmdStr);
            string retStr = string.Empty;

            SettingDBConnection.Connection.selectData(CommandSqlDictionary.getLink, parameters,
                (SQLiteDataReader reader) =>
                {
                    while (reader.Read())
                    {
                        if (string.IsNullOrEmpty(retStr))
                        {
                            retStr += reader["link_command"].ToString();
                        }
                        else
                        {
                            retStr += "," + reader["link_command"].ToString();
                        }
                    }
                });
            return retStr; 
        }
        /// <summary>
        /// コマンド用のdllリストを抽出します。
        /// </summary>
        /// <returns></returns>
        public List<SimpleDataBean> getDllList()
        {
            List<SimpleDataBean> retData = new List<SimpleDataBean>();
            SettingDBConnection.Connection.selectData("SELECT LIB_NAME FROM TBL_DLL",
                (SQLiteDataReader reader) =>
            {
                while (reader.Read())
                {
                    retData.Add(new SimpleDataBean(reader["LIB_NAME"].ToString()));
                }
            });
            return retData;
        }
    }
}
