﻿using System;
using System.Collections.Generic;
using System.Data.SQLite;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.connection;


namespace com.andoutomo.kybernetes.data.accessor
{
    public class CategoryDataAccessor
    {
        public static CategoryDataAccessor getObject
        {
            get
            {
                if (accessor == null)
                {
                    accessor = new CategoryDataAccessor();
                }
                return accessor;
            }
        }

        private static CategoryDataAccessor accessor;
        private CategoryDataAccessor()
        {
            
        }

        /// <summary>
        /// DBテーブル"MST_CATEGORY"から、呼び出すクラス名を取得する
        /// </summary>
        /// <param name="commandStr">呼び出したコマンド(引数は別)</param>
        /// <returns>コマンドデータ</returns>
        public CategoryData getCategoryFromName(string categName)
        {
            CategoryData result = null;
            List<object> list = new List<object>();
            list.Add(categName);
            TaskDBConnection.Connection.selectData(SqlDictionary.getCategoryFromCategName, list,
            (SQLiteDataReader reader) =>
            {
                if (reader.HasRows != false)
                {
                    result = new CategoryData();
                    reader.Read();
                    result.CategId = Convert.ToInt32(reader["CategID"].ToString());
                    result.BGColor = Convert.ToInt32(reader["BGCOLOR"].ToString());
                    result.FRColor = Convert.ToInt32(reader["FRCOLOR"].ToString());
                }
            });
            return result;
        }

        public CategoryData getCategoryFromID(int id)
        {
            CategoryData result = null;
            List<object> list = new List<object>();
            list.Add(id);
            TaskDBConnection.Connection.selectData(SqlDictionary.getCategoryFromCategId, list,
            (SQLiteDataReader reader) =>
            {
                if (reader.HasRows != false)
                {
                    result = new CategoryData();
                    reader.Read();
                    result.CategId = Convert.ToInt32(reader["CategID"].ToString());
                    result.Category = reader["Category"].ToString();
                    result.BGColor = Convert.ToInt32(reader["BGCOLOR"].ToString());
                    result.FRColor = Convert.ToInt32(reader["FRCOLOR"].ToString());
                }
            });
            return result;
        }

        /// <summary>
        /// 全カテゴリを取得します。
        /// </summary>
        /// <returns></returns>
        public List<CategoryData> getAllCategory()
        {
            List<CategoryData> result = new List<CategoryData>();
            TaskDBConnection.Connection.selectData(SqlDictionary.getALLCategory, 
                (SQLiteDataReader reader) =>
                {
                    while (reader.Read())
                    {
                        CategoryData wkResult = new CategoryData();
                        wkResult.CategId = Convert.ToInt32(reader["CategID"].ToString());
                        wkResult.Category = reader["Category"].ToString();
                        wkResult.BGColor = Convert.ToInt32(reader["BGCOLOR"].ToString());
                        wkResult.FRColor = Convert.ToInt32(reader["FRCOLOR"].ToString());
                        result.Add(wkResult);
                    }
                });
            return result;
        }
    }
}
