﻿using System.Text;

namespace com.andoutomo.kybernetes.data.DAO
{
    public class TimeAreaData
    {
        private string _areastr;
        private TimeComponent _startTime;
        private TimeComponent _endTime;

        public string AreaStr
        {
            get { return _areastr; }
            set { this._areastr = value; }
        }
        public TimeComponent StartTime
        {
            get { return _startTime; }
            set { this._startTime = value; }
        }
        public TimeComponent EndTime
        {
            get { return _endTime; }
            set { this._endTime = value; }
        }
        public string TextForDropDown
        {
            get
            {
                StringBuilder wkStr = new StringBuilder();
                wkStr.Append(_areastr).Append(" (");
                wkStr.Append(_startTime.ToString()).Append(" - ");
                wkStr.Append(_endTime.ToString()).Append(")");
                return wkStr.ToString();
            }
        }

    }
    public class TimeAreaCalcData : TimeAreaData
    {
        public bool isInArea(TimeComponent targetTime)
        {
            return (StartTime.TotalMinute <= targetTime.TotalMinute && targetTime.TotalMinute < EndTime.TotalMinute);
        }
        public int Span
        {
            get
            {
                return EndTime.getSubtractionMinute(StartTime);
            }
        }
        /// <summary>
        /// 予想時間(分)
        /// </summary>
        public int ForcastMin
        {
            get;
            set;
        }
        /// <summary>
        /// 実績時間(分)
        /// </summary>
        public int ActualMin
        {
            get;
            set;
        }
        /// <summary>
        /// 残り時間
        /// </summary>
        public int RemainMin
        {
            get;
            set;
        }
    }

}
