﻿
using System.Text;
namespace com.andoutomo.kybernetes.data.DAO
{
    public class TaskData
    {
        private int taskid;
        private int sortid;
        private DateComponent doDate;
        private string timeArea;
        private string category;
        private string contents;
        private int forecastMin;
        private TimeComponent startTime;
        private TimeComponent endTime;
        private int isRepeat;
        private int bgColor;
        private int frColor;
        private DateComponent _today;
        private int hasComment;

        private int categID;


        private string project;
        private string tags;
        private string comment;

        public int TaskID
        {
            get { return taskid; }
            set { this.taskid = value; }
        }
        public int SortID
        {
            get { return sortid; }
            set { this.sortid = value; }
        }
        public DateComponent DoDate
        {
            get { return doDate; }
            set { this.doDate = value; }
        }
        public string TimeArea
        {
            get { return timeArea; }
            set { this.timeArea = value; }
        }
        public string Category
        {
            get { return category; }
            set { this.category = value; }
        }
        public int CategID
        {
            get { return categID; }
            set { this.categID = value; }
        }

        public string Contents
        {
            get { return contents; }
            set { this.contents = value; }
        }
        public decimal forecastHour
        {
            get {
                decimal wkMin = forecastMin;
                return decimal.Round(wkMin / 60, 2);
            }
            set
            {
                this.forecastMin = decimal.ToInt32(value * 60);
            }
        }
        public string getForcastHourStr
        {
            get { return this.forecastHour.ToString("0.00"); }
        }
        public int ForecastMin
        {
            get { return forecastMin; }
            set { this.forecastMin = value; }
        }
        public int RealMin
        {
            get
            {
                if (startTime.IsValid == false) { return 0; }
                else
                {
                    if (endTime.IsValid)
                    {
                        return endTime.getSubtractionMinute(startTime);
                    }
                    else
                    {
                        return 0;
                    }
                }
            }
        }
        public TimeComponent StartTime
        {
            get { return startTime; }
            set { this.startTime = value; }
        }
        public TimeComponent EndTime
        {
            get { return endTime; }
            set { this.endTime = value; }
        }
        public bool isComplete
        {
            get { return endTime != null && endTime.IsValid; }
        }
        public int IsRepeat
        {
            get { return isRepeat; }
            set
            {
                this.isRepeat = value;
            }
        }
        public int BgColor
        {
            get { return bgColor; }
            set { this.bgColor = value; }
        }
        public int FrColor
        {
            get { return frColor; }
            set { this.frColor = value; }
        }
        public DateComponent Today
        {
            private get { return _today; }
            set { this._today = value; }
        }
        private bool isToday
        {
            get { return 0 == doDate.calculateDateDiff(_today); }
        }
        private int SpanOfDate
        {
            get { return doDate.calculateDateDiff(_today); }
        }
        public string Indicator
        {
            get
            {
                if (isToday)
                {
                    if (isComplete)
                    {
                        return "■";
                    }
                    else
                    {
                        return "□";
                    }
                }
                //未来分(SpanOfDateが正の数)
                else if (SpanOfDate > 0)
                {
                    return "◎";
                }
                //過去分(SpanOfDateが負の数)
                else
                {
                    return "☆";
                }
            }
        }

        public static string CSVHeader
        {
            get
            {
                return "日付,曜,@,ID,カテゴリ,内容,予測時間(H),予測時間(m),実績,開始,終了,プロジェクト,タグ,最終コメント";
            }
        }
        public string CSVData
        {
            get
            {
                StringBuilder builder = new StringBuilder();
                builder.Append(this.doDate.getDateString()).Append(",");
                builder.Append(this.doDate.getDowStr()).Append(",");
                builder.Append(this.timeArea).Append(",");
                builder.Append(this.sortid).Append(",");
                builder.Append(this.category).Append(",");
                builder.Append(this.contents).Append(",");
                builder.Append(this.forecastHour).Append(",");
                builder.Append(this.forecastMin).Append(",");
                builder.Append(this.RealMin).Append(",");
                builder.Append(this.startTime.ToString()).Append(",");
                builder.Append(this.endTime.ToString()).Append(",");
                builder.Append(this.project).Append(",");
                builder.Append(this.tags.Replace(',','|')).Append(",");//タグはカンマを変換する
                builder.Append(this.comment);
                return builder.ToString(); 
            }
        }

        public int HasComment
        {
            get { return hasComment; }
            set { this.hasComment = value; }
        }

        public string Project
        {
            get { return project; }
            set { this.project = value; }
        }
        public string Tags
        {
            get { return tags; }
            set { this.tags = value; }
        }
        public string Comment
        {
            private get { return comment; }
            set { this.comment = value; }
        }
    }
}
