﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.control;
using System.IO;

namespace com.andoutomo.kybernetes.command.batch
{
    class batchCommand:AbCommand
    {
        private string batchFilePath;
        protected override bool execute()
        {
            BatchCommandArg param = (BatchCommandArg)argument;

            string[] batchArgs;
            if (param.needSelect)
            {
                batchFilePath = form.invokeShellDialog();
                 batchArgs = new string[0];
            }
            else
            {
                batchFilePath = param.BatchFilePath;
                 batchArgs = param.BatchArguments;    
            }

            if (string.IsNullOrEmpty(batchFilePath))
            {
                message = "処理をキャンセルしました。";
                return true;
            }

            string strCmd="";
            try
            {
                using (StreamReader sr = new StreamReader(
                    batchFilePath, Encoding.GetEncoding("Shift_JIS")))
                {

                    while ((strCmd = sr.ReadLine()) != null)
                    {
                        for (int i = 0; i < batchArgs.Length; i++)
                        {
                            strCmd = strCmd.Replace("%" + (i + 1), batchArgs[i]);
                        }
                        if (strCmd.Contains('%'))
                        {
                            return false;
                        }

                        form.cmdForBatch(strCmd);
                    }
                }
            }
            catch (Exception e)
            {
                throw new KybernetesApplicationException(e);
            }
            message = "バッチ処理が完了しました。";
            return true;
        }
        string message = string.Empty;
        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
