﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.accessor;
using System.Windows.Forms;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command
{
    class TimerCommand:AbCommand
    {
        protected override bool execute()
        {
            TimerCommandArg param = (TimerCommandArg)argument;

            int timerMinute;
            string timerTitle = string.Empty;
            if (param.manualSetting)
            {
                string wkMinute = form.showInputBox("タイマーを起動します。何分に設定しますか？", ImeMode.NoControl);
                if (string.IsNullOrEmpty(wkMinute))
                {
                    timerMinute = 0;
                }
                else
                {
                    timerMinute = Convert.ToInt32(wkMinute);
                }
            }
            else
            {
                int sortID = param.sortID;

                TaskData data = TaskDataAccessor.getObject.getTask(sortID);
                if (data == null)
                {
                    base.errorType = ErrorType.DataNotFound;
                    return false;
                }
                timerTitle = data.Contents;

                //進行中のタスクだった場合
                if (data.isComplete == false && data.StartTime.IsValid)
                {
                    //経過時間(現在時刻-スタート時刻)
                    int keikaMinute = TimeComponent.justNow().getSubtractionMinute(data.StartTime);
                    timerMinute = data.ForecastMin - keikaMinute;

                }
                //そうでない場合は、見積もり時間を設定する
                    //(0の場合の処置はFormで実施する)
                else
                {
                    timerMinute = data.ForecastMin;
                }

            }
            if (string.IsNullOrEmpty(timerTitle))
            {
                form.showTimer(timerMinute);
            }
            else
            {
                form.showTimer(timerMinute, timerTitle);
            }
            return true;
        }

        protected override string turnMessage()
        {
            return base.DefaultNormalMessage;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
