﻿using com.andoutomo.kybernetes.data.accessor;

namespace com.andoutomo.kybernetes.command.SYSTEM
{
    class LogModeCommand:AbCommand
    {
        LogModeCommandArg param;
        private string message;
        protected override bool execute()
        {
            param = (LogModeCommandArg)argument;
            SettingDataAccessor accessor = SettingDataAccessor.getObject;

            if (param.showMode)
            {
                control.LogMode mode = accessor.getLogMode();
                message ="現在のログモードは " + mode.ToString() + " です。";
                return true;
            }
            else
            {
                switch (param.LogModeToChange)
                {
                    case control.LogMode.Debug:
                        message = "ログモードをDebugに変更します。変更は再起動後に有効になります。";
                        return accessor.changeLogModeToDebug();
                        
                    case control.LogMode.Trace:
                        message = "ログモードをTraceに変更します。変更は再起動後に有効になります。";
                        return accessor.changeLogModeToTrace();
                        
                    case control.LogMode.Error:
                        message = "ログモードをErrorに変更します。変更は再起動後に有効になります。";
                        return accessor.changeLogModeToError();
                        
                    default:
                        break;
                }
                return false;
            }
        }

        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
