﻿using System;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command
{
    class DateCommandArg:CommandArg
    {
        public void split(string arguments)
        {
            string[] spaceSplitData = arguments.Split(' ');
            if (spaceSplitData.Length < 2)
            {
                splitResult = false;
                return;
            }
            string dateString = spaceSplitData[1];
            if (dateString.ToLower() == "today")
            {
                TodayDateComp = new DateComponent(DateTime.Today.ToString("yyyyMMdd"));
                splitResult = true;
            }
            else
            {
                try
                {
                    TodayDateComp = new data.DateComponent(dateString);
                    splitResult = true;
                }
                catch (Exception e)
                {
                    splitResult = false;
                }
            }
        }

        public DateComponent TodayDateComp
        {
            get;
            private set;
        }

        bool splitResult;

        public bool getSplitResult()
        {
            return splitResult;
        }
    }
}
