﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.reference
{
    class SimulateCommand:AbCommand
    {
        string message;
        protected override bool execute()
        {
            SimulateCommandArg param = (SimulateCommandArg)argument;
            DateComponent searchDate = param.targetDate;

            DateComponent todayDate = SettingDataAccessor.getObject.getToday();
            TaskDataAccessor dataAccess = TaskDataAccessor.getObject;
            List<TaskData> dataList;
            List<string> retList = new List<string>();

            if (searchDate != null)
            {
                dataList = dataAccess.getDailyTaskList(searchDate);
            }
            else
            {
                dataList = dataAccess.getToDayTaskList();
            }
            if (dataList.Count == 0)
            {
                message = "対象タスクがありません。";
                return false;
            }
            TimeComponent baseTime = TimeComponent.justNow();
            
            retList.Add("現在の時刻 " + baseTime.ToString());
            retList.Add(string.Empty);
            bool alreadySetFlg = false;
            foreach (TaskData data in dataList)
            {
                if (data.isComplete)
                {
                    continue;
                }
                else if (data.StartTime.IsValid)
                {
                    //実行中のタスクを開始時間として取得していない場合
                    if (alreadySetFlg)
                    {
                        continue;
                    }
                    //既に取得している場合は、二重取得をしない。
                    else
                    {
                        baseTime = data.StartTime;
                        alreadySetFlg = true;
                    }
                }

                string wkStartTime = baseTime.ToString();
                baseTime.add(data.ForecastMin);
                string wkEndTime = baseTime.ToString();

                retList.Add(" " + data.SortID + " " + wkStartTime + " ～ " + wkEndTime + "  " + data.Contents);

            }
            retList.Add(string.Empty);
            retList.Add("終了予定時間 " + baseTime.ToString());

            form.addMultiText(retList);

            return true;
        }

        protected override string turnMessage()
        {
            return string.Empty;
        }

        protected override string turnErrorMessage()
        {
            return string.IsNullOrEmpty(message) ? base.DefaultErrorMessage : message;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
