﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.command.template;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.accessor;

namespace com.andoutomo.kybernetes.command.reference
{
    class ShowCommand:AbCommand
    {
        protected override bool execute()
        {
            StandardCommandArg param = (StandardCommandArg)argument;
            int sortID = param.sortID;

            TaskData data = TaskDataAccessor.getObject.getTask(sortID);
            if (data == null)
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }
            List<string> resultList = new List<string>();

            //題名(作業名とカテゴリ)
            resultList.Add(data.SortID + " " + data.Contents + " (" + data.Category + ")");

            //予測と実績
            string wkForecastReal = string.Empty;
            wkForecastReal += "予測 " + data.ForecastMin + "分";
            if (data.RealMin > 0)
            {
                wkForecastReal += " 実績 " + data.RealMin + "分";
                wkForecastReal += " (差異 " + (data.RealMin - data.ForecastMin) + "分)";
            }
            resultList.Add(wkForecastReal);
            string wkStartEnd = string.Empty;

            //開始と終了
            if (data.StartTime.IsValid)
            {
                wkStartEnd += data.StartTime.ToString() + "開始";
            }
            if (data.EndTime.IsValid)
            {
                wkStartEnd += " " + data.EndTime.ToString() + "終了";
            }
            if (!string.IsNullOrEmpty(wkStartEnd))
            {
                resultList.Add(wkStartEnd);
            }

            //プロジェクトとタグ
            string wkPrjAndTags = string.Empty;
            if (!string.IsNullOrEmpty(data.Project))
            {
                wkPrjAndTags += "プロジェクト：" + data.Project;
            }
            if (!string.IsNullOrEmpty(data.Tags))
            {
                wkPrjAndTags += " タグ：" + data.Tags;
            }
            if (!string.IsNullOrEmpty(wkPrjAndTags))
            {
                resultList.Add(wkPrjAndTags);
            }

            //Comment
            List<CommentData> comments = CommentDataAccessor.getObject.getComment(data.TaskID);
            foreach (CommentData com in comments)
            {
                resultList.Add("------ " + com.CreateDateStr + " ------");
                resultList.Add(com.Comment);
            }


            form.addMultiText(resultList);

            return true;
        }

        protected override string turnMessage()
        {
            return string.Empty;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
