﻿using System.Collections.Generic;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data;

namespace com.andoutomo.kybernetes.command.reference
{
    class PwdCommand:AbCommand
    {
        protected override bool execute()
        {
            List<TaskData> dataList = TaskDataAccessor.getObject.getPwdTaskList();

            List<string> retList = new List<string>();
            if (dataList.Count > 0)
            {
                retList.Add("現在実施中のタスクは以下のとおりです。");
                retList.Add(string.Empty);

                foreach (TaskData data in dataList)
                {
                    retList.Add(data.SortID + "  " + data.Contents + " (" + data.Category + ") ");
                    retList.Add(" " + data.StartTime.ToString() + "～ 予想:" + data.forecastHour + "時間");
                    //経過時間(現在時刻-スタート時刻)
                    int keikaMinute = TimeComponent.justNow().getSubtractionMinute(data.StartTime);
                    if (keikaMinute > data.ForecastMin)
                    {
                        retList.Add(" 現在" + keikaMinute + "分経過 " + (keikaMinute - data.ForecastMin) + "分 オーバー");
                    }
                    else
                    {
                        retList.Add(" 現在" + keikaMinute + "分経過 あと" + (data.ForecastMin - keikaMinute ) + "分");
                    }
                }
            }
            else
            {
                retList.Add("現在実施中のタスクはありません。");
                
                TimeComponent lastEndtime = TaskDataAccessor.getObject.getNextStartTime(SettingDataAccessor.getObject.getToday());
                if (lastEndtime != null && lastEndtime.IsValid)
                {
                    int keikaMinute = TimeComponent.justNow().getSubtractionMinute(lastEndtime);
                    retList.Add("直近タスク完了から" + keikaMinute + "分経過");
                }

            }
            
            form.addMultiText(retList);

            return true;
        }

        protected override string turnMessage()
        {
            return string.Empty;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
