﻿using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.andoutomo.kybernetes.command.Control
{
    class SVCallCommand:AbCommand
    {
        private int sortID;

        protected override bool execute()
        {
            SVCallCommandArg param = (SVCallCommandArg)argument;
            TaskData data = new TaskData();
            TaskDataAccessor accessor = TaskDataAccessor.getObject;

            data.Contents = string.IsNullOrEmpty(param.TaskTitle) ? "- 割り込み作業 -" : "- " + param.TaskTitle;
            
            data.DoDate = SettingDataAccessor.getObject.getToday();
            data.TimeArea = TimeAreaDataAccessor.getObject.getDefaultTimeArea(TimeComponent.justNow()).ToUpper();
            if(string.IsNullOrEmpty(data.TimeArea))
            {
                data.TimeArea ="Z";
            }
            data.CategID = 0;
            data.ForecastMin = 0;


            data.TaskID = accessor.getMaxTaskID();
            data.SortID = accessor.getMaxSortID();
            sortID = data.SortID;

            accessor.insertTask(data);
            accessor.startTask(data.SortID, TimeComponent.justNow());
            accessor.updateTagofTask(data.SortID, "!!");
            return true;
        }

        protected override string  turnMessage()
        {
 	        return "割り込みタスク " + sortID + " を追加しました。";
        }

        protected override string  turnErrorMessage()
        {
 	        return base.DefaultErrorMessage;
        }

        protected override string  turnSplitErrorMessage()
        {
         	return base.DefaultSplitErrorMessage;
        }
    }
}
