﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;
using com.andoutomo.kybernetes.view;
using System.Windows.Forms;

namespace com.andoutomo.kybernetes.command
{
    class EndCommand:AbCommand
    {
        string message;
        EndCommandArg param;
        protected override bool execute()
        {
            param = (EndCommandArg)argument;

            TaskData _newData = TaskDataAccessor.getObject.getTask(param.sortID);
            if (_newData == null)
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }
            if (_newData.StartTime == null || _newData.StartTime.IsValid == false)
            {
                message = "このタスクは開始されていません。startコマンドで開始してから終了してください。";
                return true;

            }
            if(_newData.EndTime != null && _newData.EndTime.IsValid == true){
                if (!YesNoDialog.show("本タスクは既に終了しています。終了時間を更新しますか？"))
                {
                    message = "処理を中断しました。";
                    return true;
                }
            }
            if (TaskDataAccessor.getObject.endTask(param.sortID, param.EndTime))
            {
                string endingComment = form.showInputBox("お疲れ様でした。本タスクへのコメントをどうぞ。", ImeMode.Hiragana);
                if (!string.IsNullOrEmpty(endingComment))
                {
                    CommentData data = new CommentData();
                    data.TaskID = _newData.TaskID;
                    data.Comment = endingComment;

                    CommentDataAccessor.getObject.insertComment(data);
                }

                if (TaskDataAccessor.getObject.isRepeatTask(param.sortID))
                {
                    string nextDay = form.showInputBox("次回は何日後ですか？0の場合は繰り返しません。","1");
                    if (nextDay != "0")
                    {
                        _newData.DoDate.addDate(int.Parse(nextDay));
                        _newData.TaskID = TaskDataAccessor.getObject.getMaxTaskID();
                        _newData.SortID = TaskDataAccessor.getObject.getMaxSortID();


                        //_newData.CategID = CategoryDataAccessor.getObject.getCategoryFromName(_newData.Category).CategId;

                        TaskDataAccessor.getObject.insertTask(_newData);

                        //リピート対象としたタスクは複製後もリピート対象とする。
                        TaskDataAccessor.getObject.setRepeatTask(_newData.SortID, true);

                        message = "タスク " + param.sortID + " を終了します。次回は" + _newData.DoDate.getDateString() + "です。";
                        return true;
                    }
                }
                message = "タスク " + param.sortID + " を終了します。";
                return true;
            }
            return false;
        }

        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
