﻿using System;
using com.andoutomo.kybernetes.data;
using com.andoutomo.kybernetes.command.template;

namespace com.andoutomo.kybernetes.command.Control
{
    class DelayCommandArg:StandardCommandArg
    {
        public DateComponent nextDate
        {
            get;
            private set;
        }
        public int DateToSkip
        {
            get;
            private set;
        }

        protected override void split()
        {
            if (splitData.Length == 3)
            {
                if (splitData[2].Contains("/"))
                {
                    nextDate = new DateComponent(splitData[2].Replace("/", ""));
                }
                else if (splitData[2].Length < 4)
                {
                    DateToSkip = Convert.ToInt32(splitData[2]);
                }
                else
                {
                    nextDate = new DateComponent(splitData[2]);
                }
                
                isValid = true;
            }
            else if (splitData.Length == 2)
            {
                nextDate = null;
                DateToSkip = int.MinValue;
                isValid = true;
            }
            else
            {
                isValid = false;
            }

        }
    }
}
