﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class ClearCommentCommand:AbCommand
    {
        protected override bool execute()
        {
            ClearCommentCommandArg param = (ClearCommentCommandArg)argument;
            if (param.delDate != null)
            {
                if (CommentDataAccessor.getObject.deleteDailyComment(param.delDate))
                {
                    message = param.delDate.getDateString() + "のコメントを削除しました。";
                    return true;
                }
                else
                {
                    return false;
                }
            }
            else if (param.SortID != 0)
            {
                TaskData taskData = TaskDataAccessor.getObject.getTask(param.SortID);
                if (taskData != null)
                {
                    if (CommentDataAccessor.getObject.deleteTaskComment(taskData.TaskID))
                    {
                        message = "タスクNo." + param.SortID + " のコメントを削除しました";
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    base.errorType = ErrorType.DataNotFound;
                    return false;
                }
            }
            else
            {
                return false;
            }
        }
        private string message;
        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
