﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class ChnumCommand:AbCommand
    {
        int before;
        int next;
        protected override bool execute()
        {
            ChnumCommandArg param = (ChnumCommandArg)argument;
            before = param.sortID;
            next = param.nextSortID;
            TaskData _target = TaskDataAccessor.getObject.getTask(before);
            if (_target == null)
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }
            return TaskDataAccessor.getObject.changeNumber(_target.TaskID, next);
        }

        protected override string turnMessage()
        {
            return "タスク番号 " + before + " を " + next + " に変更しました。";
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
