﻿using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class ChAreaCommand:AbCommand
    {
        ChAreaCommandArg param;
        protected override bool execute()
        {
            param = (ChAreaCommandArg)argument;

            if (!param.dataExists())
            {
                base.errorType = ErrorType.DataNotFound;
                return false;
            }

            return TaskDataAccessor.getObject.changeArea(param.sortID, param.nextTimeArea);
        }

        protected override string turnMessage()
        {

            return "タスク" + param.sortID + " をエリア" + param.nextTimeArea + "に変更しました。";
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
