﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class AddTagCommand:AbCommand
    {
        string message;
        protected override bool execute()
        {
            AddTagCommandArg param = (AddTagCommandArg)argument;
            TaskDataAccessor accessor = TaskDataAccessor.getObject;
            string wkStr;
            if (param.useDialog)
            {
                List<SimpleDataBean> beanList = accessor.getTagList();
                wkStr = form.showDropBoxInputBox(beanList, "タグを入力してください。");

                if (wkStr == null)
                {
                    message = "処理を中断しました。";
                    return false;
                }
            }
            else
            {
                wkStr = param.tagName;
            }
            message = "タグを追加しました。";
            return accessor.updateTagofTask(param.sortID, wkStr);
        }

        protected override string turnMessage()
        {
            if (string.IsNullOrEmpty(message))
            {
                return base.DefaultNormalMessage;
            }
            return message;
        }

        protected override string turnErrorMessage()
        {
            return base.DefaultErrorMessage;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
