﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using com.andoutomo.kybernetes.data.accessor;
using com.andoutomo.kybernetes.data.DAO;

namespace com.andoutomo.kybernetes.command.Control
{
    class AddProjectCommand:AbCommand
    {
        string message;
        protected override bool execute()
        {
            AddProjectCommandArg param = (AddProjectCommandArg)argument;
            string wkStr;
            if (param.useDialog)
            {
                List<SimpleDataBean> beanList =TaskDataAccessor.getObject.getProjectList();
                wkStr = form.showDropBoxInputBox(beanList, "プロジェクトを入力してください。");

                if (wkStr == null)
                {
                    message = "処理を中断しました。";
                    return true;
                }
            }
            else
            {
                wkStr = param.prjName;
            }
            message = "プロジェクトを設定しました。";
            return TaskDataAccessor.getObject.updateProjectofTask(param.sortID,wkStr);
        }

        protected override string turnMessage()
        {
            return message;
        }

        protected override string turnErrorMessage()
        {
            if (string.IsNullOrEmpty(message))
            {
                return base.DefaultErrorMessage;
            }
            return message;
        }

        protected override string turnSplitErrorMessage()
        {
            return base.DefaultSplitErrorMessage;
        }
    }
}
